/* ***************************************************************/
/*
** Name:         IDAXPSIN.CMD
**
** Full Name:    Post installation exit for Project Smarts
**
** Description:  Updates the WorkFrame project template files
**               shipped with distributed tools to inherit from
**               VAC++ main project. Adds distributed application
**               entry into the Project Smarts catalog
**
** Comments:     Since the system has not been re-IPLed yet at this
**               point in the installation process, the value
**               of IDAROOT must be passed in as an argument.
**               Also, is is assumed VAC++ has been installed
**               and the system has been re-IPLed (we pick up
**               several VAC++ environment variables)
**
** ****************************************************************
**
** copyright:    Licensed Materials - Property of IBM
**
**               DAD Tools (C) Copyright IBM Corporation 1995.
**               All rights reserved.
**               US Government Users Restricted Rights - Use,
**               duplication or disclosure restricted by GSA ADP
**               Schedule Contract with IBM Corp.
**
**               See Copyright Instructions, G120-2083.
**
** ****************************************************************
*/

/*---------------------------------------------------------------*/
/* set return codes                                              */
/*---------------------------------------------------------------*/

OK = 0
ERROR = x2d('0099')
exitrc = OK

ida. = 0 /* recovery state */

/*---------------------------------------------------------------*/
/* Get path of the UNICORN install root (IDAROOT env variable)   */
/* MUST BE FULLY QUALIFIED NAME drive:path                       */
/*---------------------------------------------------------------*/

parse upper arg idaRoot .
if idaRoot=''
then call Abort('Invalid parameter list')
idaRoot = strip(idaRoot,'T','\')
idaInclude = idaRoot'\INCLUDE'

/*---------------------------------------------------------------*/
/* obtain default VAC++ project template id                      */
/*---------------------------------------------------------------*/

env = 'OS2ENVIRONMENT'
dfltProject = value('IWF.DEFAULT_PRJ',,env)
if dfltProject = ''
then do
   say 'Unable to find configuration variable "IWF.DEFAULT_PRJ"'
   say 'Using default value "CPPDFTPRJ"'
   dfltProject = 'CPPDFTPRJ'
end

/*---------------------------------------------------------------*/
/* load REXX utility routine                                     */
/*---------------------------------------------------------------*/

rc = RxFuncAdd("SysSetObjectData","REXXUTIL","SysSetObjectData")
if rc > 1
then call Abort('Unable to load REXX utility package REXXUTIL, rc='rc)
else ida.stateREXXUTIL = 1

/*---------------------------------------------------------------*/
/* load WorkFrame catalog utility routines                       */
/*---------------------------------------------------------------*/

rc = RxFuncAdd('iwfLoadFuncs', 'IWFREXX', 'iwfLoadFuncs');
if rc > 1
then call Abort('Unable to load REXX utility package IWFREXX, rc='rc)
else ida.stateREXXWF = 1
rc = iwfLoadFuncs();

/*---------------------------------------------------------------*/
/* set inheritance for project templates (application+partition) */
/*---------------------------------------------------------------*/

appProject = idaRoot || '\TEMPLATE\IDA_APP'
call status("Updating project template" appProject "to inherit from" dfltProject)
rc = SysSetObjectData(appProject, "INHERITLIST=<"dfltProject">;")
if rc=0
then call Abort('Unable to update project "'appProject'"')

ptnProject = idaRoot || '\TEMPLATE\IDA_PTN'
call status("Updating project template" ptnProject "to inherit from" dfltProject)
rc = SysSetObjectData(ptnProject, "INHERITLIST=<"dfltProject">;")
if rc=0
then call Abort('Unable to update project "'ptnProject'"')

/*---------------------------------------------------------------*/
/* open Project Smarts catalog                                   */
/*---------------------------------------------------------------*/

stem = "stem"
stem.pszCatalog = "<VAPrjSmarts>"
call status("updating Project Smarts catalog" stem.pszCatalog)
rc = iwfOpenCatalog(stem);
if (rc <> 0)
then call Abort("Unable to open the Project Smarts catalog, rc="rc);

/*---------------------------------------------------------------*/
/* update Project Smarts catalog with our entry                  */
/*---------------------------------------------------------------*/

stem.pszName              =  "Distributed Logic Application"
line1                     =  "A template for a distributed logic application. "
line2                     =  "The application is composed of several components (clients, servers, intermediate nodes). "
line3                     =  "Each component is created as a separate project folder. "
line4                     =  "All component folders are nested within a single application folder. "
line5                     =  "You can use the Visual Builder, Data Access Builder or an editor to create definitions of distributable classes. "
line6                     =  "The distribution commands provided within the component folders will assist you with creation of the required distribution logic. "
stem.pszDescription       = line1||line2||line3||line4||line5||line6
stem.pszSourceLocation    = idaRoot
stem.pszInstallScript     = "IDAXPS.CMD"
stem.pszInstallParameters = "%catalog% %project% %location%"

rc = iwfUpdateCatalog(stem);
if (rc <> 0)
then call Abort("Unable to update the Project Smarts catalog, rc="rc);

/*---------------------------------------------------------------*/
/* close the catalog                                             */
/*---------------------------------------------------------------*/

rc = iwfCloseCatalog(stem);
if (rc <> 0)
then call Abort("Unable to close the Project Smarts catalogc rc="rc);

/*---------------------------------------------------------------*/
/* WE ARE DONE !!!                                               */
/*---------------------------------------------------------------*/

call Done(OK)

/*---------------------------------------------------------------*/

status:
   parse arg statusMsg
   say statusMsg

   return

/*---------------------------------------------------------------*/

Abort:
   parse arg abortMsg
   say '*ERROR*' abortMsg

   say ' '
   say 'Press "enter" to continue'
   line = linein()

   call Done(ERROR)

/*---------------------------------------------------------------*/

Done:
   arg exitRc

   if ida.stateREXXUTIL
   then do /* --- drop REXX utility functions --- */
      rc = RxFuncDrop("SysSetObjectData");
   end

   if ida.stateREXXWF
   then do /* --- drop WF utility functions --- */
      rc = iwfDropFuncs();
      rc = RxFuncDrop("iwfLoadFuncs");
   end

   exit(exitRc)

/*---------------------------------------------------------------*/
