/* ***************************************************************/
/*
** Name:         IDAXHLUN.CMD
**
** Full Name:    Uninstall distributed tools Tribble help
**
** Description:  Deletes all distributed tool entries from IWFHELP.INI
**
** Comments:
**
** ****************************************************************
**
** copyright:    Licensed Materials - Property of IBM
**
**               DAD Tools (C) Copyright IBM Corporation 1995.
**               All rights reserved.
**               US Government Users Restricted Rights - Use,
**               duplication or disclosure restricted by GSA ADP
**               Schedule Contract with IBM Corp.
**
**               See Copyright Instructions, G120-2083.
**
** ****************************************************************
*/

ida. = 0 /* recovery state */
OK = 0
ERROR = x2d('0099')

/*---------------------------------------------------------------*/
/* obtain path to workframe tribble help .ini file               */
/*---------------------------------------------------------------*/

env = 'OS2ENVIRONMENT'
helpIni = value('CPPHELP_INI',,env)
if helpIni=''
then call Abort('*ERROR* unable to establish path to IWFHELP.INI')
helpIni = strip(helpIni,'T','\')

/*---------------------------------------------------------------*/
/* load REXX utility routine                                     */
/*---------------------------------------------------------------*/

rc = RxFuncAdd("SysIni","REXXUTIL","SysIni")
if rc > 1
then call Abort('*ERROR* unable to load REXX utility "SysIni", rc='rc)
else ida.stateREXXUTIL = 1

/*---------------------------------------------------------------*/
/* read wf index looking for our key                             */
/*---------------------------------------------------------------*/

iniFile = helpIni'\IWFHELP.INI'
key   = 'DS_KEY'
wfApp = 'HELP'
wfVal = Key || D2C(0)

say 'Updating "'iniFile'"'

result = SysIni(iniFile, wfApp, 'ALL:', 'wfKey')
if result='ERROR:'
then call Abort('*ERROR* unable to read VAC++ help list')

found = 0
do i=1 to wfKey.0
   result = SysIni(iniFile, wfApp, wfKey.i)
   if result='ERROR:'
   then call Abort('*ERROR* unable to read VAC++ help list')
   else if result=wfVal
   then do /* delete all entries referencing our topics */
      found = 1
      result = SysIni(iniFile, wfApp, wfKey.i, 'DELETE:')
      if result='ERROR:'
      then say '*ERROR* unable to delete "'wfKey.i'" from VAC++ help list'
   end
end
if found=0 then say '*ERROR* distributed tool entry not in VAC++ help list'

/*---------------------------------------------------------------*/
/* delete our help topics                                        */
/*---------------------------------------------------------------*/

result = SysIni(iniFile, key, 'DELETE:')
if result='ERROR:'
then call Abort('*ERROR* unable to delete distributed tools help topics')

say 'Done'
call Done(OK)

/*---------------------------------------------------------------*/

Abort:

   parse arg abortMsg
   say abortMsg

   say ' '
   say 'Press "enter" to continue'
   line = linein()

   call Done(ERROR)

/*---------------------------------------------------------------*/

Done:

   arg exitRc

   if ida.stateREXXUTIL
   then do /* --- drop REXX utility functions --- */
      rc = RxFuncDrop("SysIni");
   end

   exit(exitRc)

/*---------------------------------------------------------------*/
