/* ***************************************************************/
/*
** Name:         IDAXHLIN.CMD
**
** Full Name:    Tribble Help install script
**
** Description:  Updates the IWFHELP.INI file with references to
**               distributed tool help files
**
** Comments:
**
** ****************************************************************
**
** copyright:    Licensed Materials - Property of IBM
**
**               DAD Tools (C) Copyright IBM Corporation 1995.
**               All rights reserved.
**               US Government Users Restricted Rights - Use,
**               duplication or disclosure restricted by GSA ADP
**               Schedule Contract with IBM Corp.
**
**               See Copyright Instructions, G120-2083.
**
** ****************************************************************
*/

/*---------------------------------------------------------------*/
/* set return codes                                              */
/*---------------------------------------------------------------*/

OK = 0
INCOMPLETE = 4
ERROR = x2d('0099')
exitrc = OK

ida. = 0 /* recovery state */

/*---------------------------------------------------------------*/
/* Obtain name of file containing the help topics to add.        */
/* File format is as follows:                                    */
/* - first line      : Topic Category (to appear on pulldown)    */
/* - subsequent lines: infFileName Description                   */
/*---------------------------------------------------------------*/

parse arg helpTopics .
if helpTopics=''
then call Abort('*ERROR* Invalid parameter list')

/*---------------------------------------------------------------*/
/* obtain path to workframe tribble help .ini file               */
/*---------------------------------------------------------------*/

env = 'OS2ENVIRONMENT'
helpIni = value('CPPHELP_INI',,env)
if helpIni=''
then call Abort('*ERROR* unable to establish path to IWFHELP.INI')
helpIni = strip(helpIni,'T','\')

/*---------------------------------------------------------------*/
/* load REXX utility routine                                     */
/*---------------------------------------------------------------*/

rc = RxFuncAdd("SysIni","REXXUTIL","SysIni")
if rc > 1
then call Abort('*ERROR* unable to load REXX utility "SysIni", rc='rc)
else ida.stateREXXUTIL = 1

/*---------------------------------------------------------------*/
/* initialize install variables                                  */
/*---------------------------------------------------------------*/

iniFile = helpIni'\IWFHELP.INI'
wfApp = 'HELP'
dsApp = 'DS_KEY'
wfVal = dsApp || D2C(0)

/*---------------------------------------------------------------*/
/* read help pulldown entry (first line in file)                 */
/*---------------------------------------------------------------*/

wfKey = getLine()
if wfKey=''
then call Abort('*ERROR* unable to read help topic file "'helpTopics'"')
wfKey = strip(wfKey)

/*---------------------------------------------------------------*/
/* read help topics and initialize variables                     */
/*---------------------------------------------------------------*/

dsApp   = 'DS_KEY'

do i=1 by 1
   topic = getLine()
   if topic = ''
   then leave
   else do
      parse var topic infFile infDesc
      dsKey.i = strip(infDesc)
      dsVal.i = strip(infFile) || D2C(0)
   end
end

/*---------------------------------------------------------------*/
/* check for no topics in file                                   */
/*---------------------------------------------------------------*/

if i=1
then call Abort('*ERROR* no help topics found in "'helpTopics'"')
dsKey.0 = i-1

/*---------------------------------------------------------------*/
/* add distributed tool entry to tribble list                    */
/*---------------------------------------------------------------*/

result = SysIni(iniFile, wfApp, wfKey, wfVal)
if result='ERROR:'
then call Abort('*ERROR* unable to add' wfKey 'to VAC++ help list')
say 'Updating "'iniFile'"'
say ' '
say wfKey

/*---------------------------------------------------------------*/
/* add distributed tool help topics                              */
/*---------------------------------------------------------------*/

do i=1 to dsKey.0
   result = SysIni(iniFile, dsApp, dsKey.i, dsVal.i)
   if result='ERROR:'
   then call Abort('*ERROR* unable to add help topic' dsKey.i 'to VAC++ help list')
   else say '->' left(dsKey.i,50) dsVal.i
end

/*---------------------------------------------------------------*/
/* We are done !!!                                               */
/*---------------------------------------------------------------*/

call Done(OK)

/*---------------------------------------------------------------*/

Abort:

   parse arg abortMsg
   say abortMsg

   say ' '
   say 'Press "enter" to continue'
   line = linein()

   call Done(ERROR)

/*---------------------------------------------------------------*/

Done:

   arg exitRc

   if ida.stateREXXUTIL
   then do /* --- drop REXX utility functions --- */
      rc = RxFuncDrop("SysIni");
   end

   exit(exitRc)

/*---------------------------------------------------------------*/

getLine:

   tmp = linein(helpTopics)
   do while(substr(tmp,1,1)='*' & tmp <> '')
      tmp = linein(helpTopics)
   end

   return(tmp)

/*---------------------------------------------------------------*/
