/********************************************************************
 * PC installer (aldsetup) control file for FreeHand 4.0  1.44mb Disks
 * Copyright (C) 1992 - 1994 Aldus Corporation.  All rights reserved.
 * Control file administrator: Alan Johnson
 ********************************************************************/

PRODUCT "FreeHand 4.0"

VERSIONREQ "2.3"

ALDUSDIRECTORY "Aldus" "AldusDirectory" "C:\ALDUS" 


/********   DBUILD SECTION  ***********/


DISK "(1)"
   {
   _C_ALDUS.94          38,
   1SCRNFH.BMP       38878,
   ALDSETUP.EXE     284720  CHECKDATE,
   FH4_144.CTL       27315,
   IDUPDATE.EXE      12048  CHECKDATE,
   WINBUMPS.EXE      37896  CHECKDATE,
   README.TXT        18651,
   aldvm.dl_         83890  "ALDUS"  CHECKDATE,
   aldwpls.dl_      147536  "ALDUS"  CHECKDATE,
   prxlngst.dl_       6144  "ALDUS"  CHECKDATE,
   aldukn.bp_        32313  "ALDUS\UKENGLSH"  CHECKDATE,
   aldukn00.vp_     258048  "ALDUS\UKENGLSH"  CHECKDATE,
   aldukn.nf_           65  "ALDUS\UKENGLSH"  CHECKDATE,
   aldukn.ud_         1024  "ALDUS\UKENGLSH"  CHECKDATE,
   BMPRDR.FH_        14336  "FH4\FH4FILT"  CHECKDATE,
   BMPWRT.FH_        24064  "FH4\FH4FILT"  CHECKDATE,
   CORELRDR.FH_      91136  "FH4\FH4FILT"  CHECKDATE,
   DRWRDR.FH_        57856  "FH4\FH4FILT"  CHECKDATE,
   TIFFWRT.FH_       27648  "FH4\FH4FILT"  CHECKDATE,
   TTRDR.FH_         16896  "FH4\FH4FILT"  CHECKDATE,
   TYPE1RDR.FH_      13312  "FH4\FH4FILT"  CHECKDATE,
   WMFRDR.FH_        52224  "FH4\FH4FILT"  CHECKDATE,
   WMFWRT.FH_        15360  "FH4\FH4FILT"  CHECKDATE,
   ALDCOLOR.AD_      60928  "FH4\FH4LIB"  CHECKDATE,
   CRAYON.AC_         2747  "FH4\FH4LIB"  CHECKDATE,
   GREYS.AC_          6840  "FH4\FH4LIB"  CHECKDATE,
   DIC-PCN.BC_       70178  "FH4\FH4LIB"  CHECKDATE,
   FH4.HL_          450603  "FH4\FH4LIB"  CHECKDATE,
   FOCOLTON.BC_      47066  "FH4\FH4LIB"  CHECKDATE,
   PANTONEC.BC_      51980  "FH4\FH4LIB"  CHECKDATE,
   PANTONEP.BC_      51980  "FH4\FH4LIB"  CHECKDATE,
   PANTONEU.BC_      51980  "FH4\FH4LIB"  CHECKDATE,
   PANTONPE.BC_      51980  "FH4\FH4LIB"  CHECKDATE,
   PCSG.BC_         162950  "FH4\FH4LIB"  CHECKDATE,
   PCSGE.BC_        162950  "FH4\FH4LIB"  CHECKDATE,
   TOYOPC.BC_        57326  "FH4\FH4LIB"  CHECKDATE,
   TRUMATCH.BC_     114242  "FH4\FH4LIB"  CHECKDATE
   }


DISK "(2)"
   {
   FH4PART1.12_     2318336,
   2SCRNFH.BMP       38878,
   FH4DEF.FT_         3728  "FH4"  CHECKDATE
   }


DISK "(3)"
   {
   3SCRNFH.BMP       38878,
   FH4LANG.DL_      592896  "FH4",
   FH4PART2.12_     825088  "FH4",
   fh4im3.dl_       282680  "FH4"  CHECKDATE,
   aldpls2.dl_      136240  "ALDUS"  CHECKDATE,
   aldncd.dl_        15742  "ALDUS"  CHECKDATE,
   nwnetapi.dl_     106047  "ALDUS"  CHECKDATE,
   aldim3rs.rs_       5888  "ALDUS\USENGLSH"  CHECKDATE,
   aldusn.bp_        32319  "ALDUS\USENGLSH"  CHECKDATE,
   aldusn.ms_         1024  "ALDUS\USENGLSH"  CHECKDATE,
   aldusn.nf_           66  "ALDUS\USENGLSH"  CHECKDATE,
   aldusn.ud_         1024  "ALDUS\USENGLSH"  CHECKDATE,
   aldusn00.vp_     339968  "ALDUS\USENGLSH"  CHECKDATE,
   aldvmres.rs_       5120  "ALDUS\USENGLSH"  CHECKDATE,
   aldwplsr.rs_       9232  "ALDUS\USENGLSH"  CHECKDATE,
   prxlngst.rs_       3072  "ALDUS\USENGLSH"  CHECKDATE,
   adiimp.fl_         3680  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   cgmimp.fl_        51920  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   chartimp.fl_       9840  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   dxfimp.fl_        44576  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   hpglimp.fl_       39936  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   lotusimp.fl_       7680  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   wpgimp.fl_        38256  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   tekimp.fl_         7160  "ALDUS\USENGLSH\FILTERS"  CHECKDATE,
   APLWIIG1.PP_      15362  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   CGENERAL.PP_       8006  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   GENERAL.PP_        8855  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   IB4029A1.PP_      19729  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   L300_493.PP_      22523  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   LH330__1.PP_      38177  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   LH530__1.PP_      35213  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   AGSELS51.PP_      28704  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   AGSELS71.PP_      29338  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   HPIII522.PP_      13163  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   HPPJXL31.PP_      19323  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   HP_3P522.PP_      13357  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   LWNTX470.PP_      12301  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   N2090522.PP_      11451  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   N890X505.PP_      12036  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   N890_470.PP_      11522  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   TKPHZR22.PP_      14300  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   AGPRO981.PP_      27985  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   APTOLLW1.PP_      22590  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   IBM17523.PP_      15372  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   QCS10503.PP_      10733  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   QMS81470.PP_      11153  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   TKPHZR32.PP_      22178  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   VT600W_1.PP_      11422  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   AMCHR518.PP_       9265  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   NCCPS801.PP_      12125  "ALDUS\USENGLSH\PPD4"  CHECKDATE,
   QCS20503.PP_      10432  "ALDUS\USENGLSH\PPD4"  CHECKDATE
   }


DISK "(4)"
   {
   4SCRNFH.BMP       38878,
   COWDEN.FH_       716445  "FH4\FH4ART",
   GUDE.FH_         507382  "FH4\FH4ART",
   VIEBAHN.FH_      132928  "FH4\FH4ART",
   LOMBART.FH_      101455  "FH4\FH4ART",
   GIOBBI.FH_        88701  "FH4\FH4ART",
   FESTA.FH_         18288  "FH4\FH4ART",
   ALDUS.FH_        315191  "FH4\FH4ART\ALDUS",
   SKIRT2.TI_        80178  "FH4\FH4ART\ALDUS",
   CREATURE.TI_      47610  "FH4\FH4ART\ALDUS",
   DESIGN1.TI_       33838  "FH4\FH4ART\ALDUS",
   SKIRT3.TI_        25210  "FH4\FH4ART\ALDUS",
   FISHETCH.TI_      50626  "FH4\FH4ART\HORNANDE",
   HORNANDE.FH_      65810  "FH4\FH4ART\HORNANDE",
   ARROWS.TI_         6648  "FH4\FH4ART\HORNANDE"
   }


/*********** DBUILD END ******************/


/*****   DIALOG & VARIABLE INITIALIZATION  *****/

INITIAL 
FH4Dir "C:\FH4"
	{
	"Type the name of the drive and directory where"
	"you want to install Aldus FreeHand files."
	" "
	"If this is the directory you want, click OK."
	}


DIALOG ModPath "&Setup" "&Manual"
{
	CAPTION "Modify your system file?"
	TEXT
	{
	"The PATH statement in AUTOEXEC.BAT must include"
	"references to your Aldus FreeHand and Aldus directories"
	"in order for the program to run.  Setup can modify this"
	"file now, or you can modify it yourself after installation."
	" "
	"If you want to edit the PATH statement yourself later,"
	"click ""Manual.""  If you want Aldus Setup to modify"
	"the PATH statement, click ""Setup."""
	}
}

DIALOG PathWarning "OK" 
{
	CAPTION "Please Note!"
	TEXT
	{
	"If you receive error messages regarding missing"
	"files when you attempt to start FreeHand, it is" 
	"because your FreeHand and Aldus directories are"
	"not on your PATH."  
	""
	"To correct this, you will need to modify your" 
	"AUTOEXEC.BAT file by adding the Aldus(\ALDUS) and"
	"FreeHand (\FH4) directories to your PATH.  For"
	"additional help check the README.TXT file located"
	"in your FreeHand directory."
	}
}

DIALOG BuffersWarning "&Continue" "&Exit"
{
	CAPTION "Low BUFFERS setting"
	TEXT
	{
	"Aldus Setup has detected that the BUFFERS setting in your "
	"CONFIG.SYS file is below 20.  You can successfully install "
	"with the current settings, but the installation process may"
	"be slowed considerably.  Increasing the value of this setting"
	"and rebooting your computer will speed up the installation time."
	}
}

DIALOG AldusLocation "OK" "Cancel" 
{
	CAPTION "Aldus Directory Creation"
	TEXT
	{
	"Type the drive letter and subdirectory where"
	"you want to install the files used by Aldus"
	"products. "
	}
}
DIALOG PrintInfo "&OK"
{
	CAPTION "Must install Drivers"
	TEXT
	{
	"The Printer Dialog will appear when you click"
	"OK.  Please install the PostScript or Universal"
	"driver from the last FreeHand disk."
	"(Not Implemented Yet) "
	" "
	"Note:  FreeHand requires that one of these new"
	"drivers be installed before you can print."
	}
}

DIALOG AldusGroup "&Continue"
{
	CAPTION "Aldus group"
	TEXT
	{
	"The Aldus Setup program has created the Aldus"
	"group window."
	" "
	"Aldus Setup and Aldus FreeHand have been added"
	"to the Aldus group.  Double-click the program icon to"
	"launch the program."
	}
}

DIALOG SucRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been"
	"successfully installed."
	}
}

DIALOG MoreInfo "&OK"
{
	CAPTION "Installer Diagnostics"
	TEXT
	{
	" "
	"You may now exit this program or choose to read the Aldus"
	"FreeHand README.TXT file, which has been added to the" 
	"View menu.  You may also choose to examine other information"
	"provided from the Diagnostics or View menus in Aldus Setup."
	" "
	"Thank you for purchasing Aldus FreeHand. Your installation"
	"is complete.  Please fill out and send in your registration card."
	}
}

DIALOG SucNoRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to examine the"
	"information provided from the Diagnostics or View menu"
	"in Aldus Setup."
	}
}

DIALOG LaunchTutorial "&Yes" "&No"
{	
	CAPTION "Launch Tutorial after install?"
	TEXT
	{
	"The ALDSETUP program can automatically start the program"
	"""Learning FreeHand"" at the conclusion of the installation."
	" "
	"Click ""Yes"" to run the tutorial at the end of this install"
        "or ""NO"" to continue."
	}
}	

/*********** INITIALIZATION END *************/


/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
/***** Global Variable Declarations *****/
SET ExeInstalled "FALSE"
SET MustReboot "FALSE"
SET Answer2 "&Manual"
SET Ans1 "&Manual"
SET NewFeatures "FALSE"
SET FullInstallation "FALSE"
SET CheckAns "FALSE"
GETALDDIR AldDir AldusLocation
GETBOOTDRIVE BootDrive
SET LearnDir "NODIR"
SET Serialize "FALSE"
SET OpenTempAns "NO"
SET TutorInstalled "FALSE"
SET RunTutorVar "&No"

SET FHPPD "FALSE"
SET PPDOnly"FALSE"


GETWINDIR WinDir
GETWINSYSDIR WinSysDir

CONCAT BootDrive "CONFIG.SYS" ConfigFullName

FILEEXIST ConfigFullName ConfigYesorNo

IF ConfigYesorNo EQS "SUCCESS"
	{
	GETSYSVARVALUE ConfigFullName "BUFFERS" BufferAmount
	IF BufferAmount LT 20 
		{
		DISPLAY BuffersWarning BufferResponse
		IF  BufferResponse EQS "&Exit" 
			{
			EXIT
			}
		} 
	}
}

PACKAGE InstallEverything "Install everything" SELECTED
	{
	/**** Package Initializations *****/

	GETALDDIR AldDir AldusLocation
	CONFIRMDIR FH4Dir
	SET Serialize "TRUE"
	
	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "SETUP" SetupDir
	CONCAT EngDir "FILTERS" FiltDir
	CONCAT FH4Dir "FH4FILT" FH4FiltDir
	CONCAT FH4Dir "FH4LIB" FH4LIBDir
	CONCAT FH4Dir "FH4FEAT" FH4FEATDir
	CONCAT FH4Dir "FH4ART" FH4ARTDir
	CONCAT FH4ARTDir "ALDUS" ALDUSDir 
	CONCAT FH4ARTDir "HORNANDE" HORNANDEDir 
	CONCAT EngDir "PPD4" APPD4Dir
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT EngDir "PPDS" PPDSDir

	BMPFILE 1SCRNFH.BMP
	BMPFILE 2SCRNFH.BMP
	BMPFILE 3SCRNFH.BMP
	BMPFILE 4SCRNFH.BMP

	/**** File Subdirectory Assignments *****/

      	FILES AldDir
		{
		aldpls2.dl_
		aldvm.dl_
		aldncd.dl_    
		nwnetapi.dl_
                aldwpls.dl_
		prxlngst.dl_
		}


    SELECT2 LANGUAGES "Select dictionary languages" AldDir
	{
	TEXT
		{
		"You can install dictionaries for more than one language,"
		"however, install only one dictionary per language."
 	
 		}
	ITEMS MIN 1
		{
		 ALDUKN.BP_+ALDUKN.NF_+ALDUKN.UD_+ALDUKN00.VP_ "UK English Standard" "UKENGLSH" "6",
		 ALDUSN.BP_+ALDUSN.NF_+ALDUSN.UD_+ALDUSN00.VP_ "US English Standard" "USENGLSH" "1"
		}
	HELP
		{
		"Select the dictionaries you want to install."
		" "
		"You can install dictionaries for more than one "
		"language, however, install only one dictionary"
		"per language. Aldus Freehand uses only the first"
		"dictionary name it finds alphabetically for each"
		"language."
		" "
		"Medical, legal, and other language dictionaries are"
		"available from Aldus Customer Service at"
		"(800)628-2320 in the U.S. and Canada. In other"
		"countries, see your local Aldus distributor or"
		"subsidiary."
		" "
		"To stop the installation without saving settings,"
		"click ""Cancel."""
		}
	} 
	FILES EngDir
		{
		aldusn.bp_   
		aldusn.ms_   
		aldusn.nf_   
		aldusn.ud_   
		aldusn00.vp_
		aldvmres.rs_ 
		aldwplsr.rs_ 
		aldim3rs.rs_ 
		prxlngst.rs_ 
		}

	FILES SetupDir
		{
		ALDSETUP.EXE
		FH4_144.CTL
		}

	FILES AUtilDir
		{
		IDUPDATE.EXE
		WINBUMPS.EXE
		}

	FILES FH4FiltDir
		{
/*		AI3RDR.FH_
		AI3WRT.FH_
		AI88WRT.FH_*/
		BMPRDR.FH_  
		BMPWRT.FH_  
		CORELRDR.FH_
		DRWRDR.FH_  
		TIFFWRT.FH_ 
		TTRDR.FH_   
		TYPE1RDR.FH_
		WMFRDR.FH_  
		WMFWRT.FH_  
		}

	FILES FH4LIBDir
		{
		ALDCOLOR.AD_
		CRAYON.AC_ 
		GREYS.AC_  
		DIC-PCN.BC_     
		FH4.HL_     
		FOCOLTON.BC_
		PANTONEC.BC_
		PANTONEP.BC_
		PANTONEU.BC_
		PANTONPE.BC_ 
		PCSG.BC_    
		PCSGE.BC_    
		TOYOPC.BC_  
		TRUMATCH.BC_
		}

	FILES FH4Dir
		{
		FH4DEF.FT_
		FH4PART1.12_
		FH4PART2.12_
		fh4im3.dl_
		README.TXT
		FH4LANG.DL_
		}

	FILES FiltDir 
		{
		adiimp.fl_      
		cgmimp.fl_     
		chartimp.fl_    
		dxfimp.fl_     
		hpglimp.fl_    
		lotusimp.fl_    
		wpgimp.fl_ 
		tekimp.fl_      
		}

	FILES  FH4ARTDir
	
		{
		 COWDEN.FH_
		 GUDE.FH_
		 VIEBAHN.FH_
		 LOMBART.FH_
		 GIOBBI.FH_
		 FESTA.FH_
		}
	
	
	FILES  ALDUSDir
	
		{
		 ALDUS.FH_
		 SKIRT2.TI_
		 CREATURE.TI_
		 DESIGN1.TI_
		 SKIRT3.TI_
		}
	
	
	FILES  HORNANDEDir
	
		{
		 FISHETCH.TI_
		 HORNANDE.FH_
		 ARROWS.TI_
		}


	/**** end File Subdirectory Assignments ****/

	SELECT1 "Select printer devices" APPD4Dir NOSELECTALL
		{
		TEXT
			{
			"Select the printer files you wish to install:"
			}
		ITEMS
			{
			AGPRO981.PP_	"AGFA_ProSet9800 v52.3",
			AGSELS51.PP_	"AGFA_SelectSet5000 v52.3",
			AGSELS71.PP_	"AGFA_SelectSet7000 v52.3",
			CGENERAL.PP_	"Color General",
			GENERAL.PP_	"General",
			NCCPS801.PP_	"Colormate PS80",
			HPIII522.PP_	"HP LaserJet III v2010.118",
			HP_3P522.PP_	"HP LaserJet IIIP v52.2",
			HPPJXL31.PP_	"HP PaintJet XL300 v2011.112",
			IBM17523.PP_	"IBM 4019 17 fonts",
			IB4029A1.PP_	"IBM LaserPrinter 4029 39 fonts",
			LWNTX470.PP_	"LaserWriter II NTX v47.0",
			APLWIIg1.PP_	"LaserWriter IIg v2010.113",
			APTOLLW1.PP_	"LaserWriter Pro 630 v2010.130",
			L300_493.PP_	"Linotronic 300 v49.3",
			LH330__1.PP_	"Linotronic 330-RIP 30 v52.3",
			LH530__1.PP_	"Linotronic 530-RIP 30 v52.3",
			TKPHZR22.PP_	"Phaser II PXi v2011.108",
			TKPHZR32.PP_	"Phaser III PXi v2011.108",
			AMCHR518.PP_	"PRISMA",
			QCS10503.PP_	"QMS ColorScript 100 Model 10",
			QCS20503.PP_	"QMS ColorScript 100 Model 20",
			QMS81470.PP_	"QMS-PS 810",
			N890_470.PP_	"Silentwriter",
			N890X505.PP_	"Silentwriter XL",
			N2090522.PP_	"Silentwriter2 90",
			VT600W_1.PP_	"Varityper VT-600P v48.0"
			}

		HELP
			{
		       	"Select the PostScript printer description (PPD) files that"
			"match the PostScript output devices you will use for"
			"draft and final output. Select only the files you need,"
			"and then click ""OK."""
			}

		}  /**** end select ppds  ***/	


	/**** INI Initializations ****/

	CONCAT FH4Dir "FH4.exe ^.FH4"  FH4_ExtText 
	CONCAT FH4Dir "FH4.exe ^.FT4"  FT4_ExtText 



	/**** INI Settings ****/
	ALDUSINI
		{
		"FreeHand4" "FreeHandFilters" FH4FiltDir,
		"FreeHand4" "FreeHandLibrary" FH4LibDir,
		"FreeHand4" "AldusFilters" FiltDir,
		"FreeHand4" "MAXIMIZE" "1",
		"FreeHand4" "TwoPassPCLPrinting" "1"
		} 

	WININI
		{
		"Extensions" "FH4" FH4_ExtText,
		"Extensions" "FT4" FT4_ExtText,
		"Aldus" "AldusDirectory" AldDir,
		"Aldus"	"FH4LangDir" "USENGLSH",
		"Aldus"	"FreeHand4Directory" FH4Dir,
		"Aldus"	"PPD4" APPD4Dir 
		}


	/*** Oninstall initializations ***/

	SET NewFeatures "TRUE"
	SET ExeInstalled "TRUE"
	SET FullInstallation "TRUE"
	SET MustReboot "TRUE"
	CONCAT SetupDir "aldsetup.exe /I" FullInstallerName

	CONCAT FH4Dir "FH4.exe" FullFHName

	/**** Oninstall Commands ******/


	ONINSTALL
		{

		ASSEMBLE "FH4.EXE"
			{
			FH4PART1.12_
			FH4PART2.12_
			}		      

		WINDOWSMENU FH4Dir "README.TXT" "&README.TXT" 

		PERSONALIZE FH4Dir "FH4LANG.DLL"


		DELETEPROGRAMITEM "Aldus" "Aldus Setup"
		DELETEPROGRAMITEM "Aldus" "Aldus FreeHand 4.0"

		
		ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
		ADDPROGRAMITEM "Aldus" FullFHName "Aldus FreeHand 4.0" FullFHName 0

		DISPLAY AldusGroup


		DISPLAY ModPath Ans1

		IF Ans1 EQS "&Setup"
			{			   
			MODIFY "AUTOEXEC.BAT" BootDrive
				{
				PATH "path" FH4Dir
				PATH "path" AldDir	  
				}
			}  


		}	

	}	/***** END FreeHand Easy Install *****/


PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{

SET Fred "Barney"
}

PACKAGE FreeHand "Aldus FreeHand 4.0" UNSELECTED
	{
	/**** Package Initializations *****/

	GETALDDIR AldDir AldusLocation
	CONFIRMDIR FH4Dir
	SET Serialize "TRUE"
	SET FHPPD "TRUE"

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "SETUP" SetupDir
	CONCAT EngDir "FILTERS" FiltDir
	CONCAT FH4Dir "FH4FILT" FH4FiltDir
	CONCAT FH4Dir "FH4LIB" FH4LIBDir
	CONCAT FH4Dir "FH4FEAT" FH4FEATDir
	CONCAT FH4Dir "FH4ART" FH4ARTDir
	CONCAT EngDir "PPD4" APPD4Dir
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT EngDir "PPDS" PPDSDir

	BMPFILE 1SCRNFH.BMP
	BMPFILE 2SCRNFH.BMP
	BMPFILE 3SCRNFH.BMP
	BMPFILE 4SCRNFH.BMP

	/**** File Subdirectory Assignments *****/

	FILES AldDir
		{
		aldpls2.dl_
		aldvm.dl_
		aldncd.dl_    
		nwnetapi.dl_
                aldwpls.dl_
		prxlngst.dl_
		}

    SELECT2 LANGUAGES "Select dictionary languages" AldDir
	{
	TEXT
		{
		"You can install dictionaries for more than one language,"
		"however, install only one dictionary per language."
		}
	ITEMS MIN 1
		{
		 ALDUKN.BP_+ALDUKN.NF_+ALDUKN.UD_+ALDUKN00.VP_ "UK English Standard" "UKENGLSH" "6",
		 ALDUSN.BP_+ALDUSN.NF_+ALDUSN.UD_+ALDUSN00.VP_ "US English Standard" "USENGLSH" "1"
		}
	HELP
		{
		"Select the dictionaries you want to install."
		" "
		"You can install dictionaries for more than one "
		"language, however, install only one dictionary"
		"per language. Aldus Freehand uses only the first"
		"dictionary name it finds alphabetically for each"
		"language."
		" "
		"Medical, legal, and other language dictionaries are"
		"available from Aldus Customer Service at"
		"(800)628-2320 in the U.S. and Canada. In other"
		"countries, see your local Aldus distributor or"
		"subsidiary."
		" "
		"To stop the installation without saving settings,"
		"click ""Cancel."""
	        }
	} 
	
	FILES EngDir
		{
		aldusn.bp_   
		aldusn.ms_   
		aldusn.nf_   
		aldusn.ud_   
		aldusn00.vp_
		aldvmres.rs_ 
		aldwplsr.rs_ 
		aldim3rs.rs_ 
		prxlngst.rs_ 
		}

	FILES SetupDir
		{
		ALDSETUP.EXE
		FH4_144.CTL
		}

	FILES AUtilDir
		{
		IDUPDATE.EXE
		WINBUMPS.EXE
		}

	FILES FH4FiltDir
		{
/*		AI3RDR.FH_
		AI3WRT.FH_
		AI88WRT.FH_*/
		BMPRDR.FH_  
		BMPWRT.FH_  
		CORELRDR.FH_
		DRWRDR.FH_  
		TIFFWRT.FH_ 
		TTRDR.FH_   
		TYPE1RDR.FH_
		WMFRDR.FH_  
		WMFWRT.FH_  
		}

	FILES FH4LIBDir
		{
		ALDCOLOR.AD_
		CRAYON.AC_ 
		GREYS.AC_  
		DIC-PCN.BC_     
		FH4.HL_     
		FOCOLTON.BC_
		PANTONEC.BC_
		PANTONEP.BC_
		PANTONEU.BC_
		PANTONPE.BC_ 
		PCSG.BC_    
		PCSGE.BC_    
		TOYOPC.BC_  
		TRUMATCH.BC_
		}

	FILES FH4Dir
		{
		FH4LANG.DL_
		FH4DEF.FT_
		FH4PART1.12_
		FH4PART2.12_
		fh4im3.dl_
		README.TXT
		}

	/**** end File Subdirectory Assignments ****/

	SELECT1 "Select printer devices" APPD4Dir NOSELECTALL
		{
		TEXT
			{
			"Select the printer files you wish to install:"
		    	}
		ITEMS
			{
			AGPRO981.PP_	"AGFA_ProSet9800 v52.3",
			AGSELS51.PP_	"AGFA_SelectSet5000 v52.3",
			AGSELS71.PP_	"AGFA_SelectSet7000 v52.3",
			CGENERAL.PP_	"Color General",
			GENERAL.PP_	"General",
			NCCPS801.PP_	"Colormate PS80",
			HPIII522.PP_	"HP LaserJet III v2010.118",
			HP_3P522.PP_	"HP LaserJet IIIP v52.2",
			HPPJXL31.PP_	"HP PaintJet XL300 v2011.112",
			IBM17523.PP_	"IBM 4019 17 fonts",
			IB4029A1.PP_	"IBM LaserPrinter 4029 39 fonts",
			LWNTX470.PP_	"LaserWriter II NTX v47.0",
			APLWIIg1.PP_	"LaserWriter IIg v2010.113",
			APTOLLW1.PP_	"LaserWriter Pro 630 v2010.130",
			L300_493.PP_	"Linotronic 300 v49.3",
			LH330__1.PP_	"Linotronic 330-RIP 30 v52.3",
			LH530__1.PP_	"Linotronic 530-RIP 30 v52.3",
			TKPHZR22.PP_	"Phaser II PXi v2011.108",
			TKPHZR32.PP_	"Phaser III PXi v2011.108",
			AMCHR518.PP_	"PRISMA",
			QCS10503.PP_	"QMS ColorScript 100 Model 10",
			QCS20503.PP_	"QMS ColorScript 100 Model 20",
			QMS81470.PP_	"QMS-PS 810",
			N890_470.PP_	"Silentwriter",
			N890X505.PP_	"Silentwriter XL",
			N2090522.PP_	"Silentwriter2 90",
			VT600W_1.PP_	"Varityper VT-600P v48.0"
			}

		HELP
			{

		       	"Select the PostScript printer description (PPD) files that"
			"match the PostScript output devices you will use for"
			"draft and final output. Select only the files you need,"
			"and then click ""OK."""
			}

		}  /**** end select ppds  ***/	



	/**** INI Settings ****/


/*	CONCAT FH4Dir "te.exe ^.tbl"  TE_ExtText */


	/**** INI Settings ****/

	ALDUSINI
		{
		"FreeHand4" "FreeHandFilters" FH4FiltDir,
		"FreeHand4" "FreeHandLibrary" FH4LibDir,
		"FreeHand4" "AldusFilters" FiltDir,
		"FreeHand4" "MAXIMIZE" "1",
		"FreeHand4" "TwoPassPCLPrinting" "1"
		} 

	WININI
		{
		"Aldus" "AldusDirectory" AldDir,
		"Aldus"	"FH4LangDir" "USENGLSH",
		"Aldus"	"FreeHand4Directory" FH4Dir,
		"Aldus"	"PPD4" APPD4Dir
		}

	/*** Oninstall initializations ***/

	SET NewFeatures "TRUE"
	SET ExeInstalled "TRUE"
	SET MustReboot "TRUE"
	CONCAT SetupDir "aldsetup.exe /I" FullInstallerName

	CONCAT FH4Dir "FH4.exe" FullFHName

	/**** Oninstall Commands ******/


	ONINSTALL
		{

		WINDOWSMENU FH4Dir "README.TXT" "&README.TXT" 

		IF FullInstallation EQS "FALSE"
			{

			ASSEMBLE "FH4.EXE"
				{
				FH4PART1.12_
				FH4PART2.12_
				}		      

			PERSONALIZE FH4Dir "FH4LANG.DLL"

			} 
		DELETEPROGRAMITEM "Aldus" "Aldus Setup"
		DELETEPROGRAMITEM "Aldus" "Aldus FreeHand 4.0"


		ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
		ADDPROGRAMITEM "Aldus" FullFHName "Aldus FreeHand 4.0" FullFHName 0

		DISPLAY AldusGroup


		DISPLAY ModPath Ans1

		IF Ans1 EQS "&Setup"
			{			   
			MODIFY "AUTOEXEC.BAT" BootDrive
				{
				PATH "path" FH4Dir
				PATH "path" AldDir	   
				}
			}  


		}	
	}	/***** END FreeHand *****/



PACKAGE PPDs "Printer description files" UNSELECTED 
{

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT EngDir "PPD4" PPDSDir
	SET PPDOnly "TRUE"

 	IF FHPPD EQS "FALSE"
       		{
		
		IF PPDOnly EQS "TRUE"
		    {


	SELECT1 "Select printer devices" PPDSDir NOSELECTALL
		{
		TEXT
			{
			"Select the printer files you wish to install:"
		        }
		ITEMS
			{
			AGPRO981.PP_	"AGFA_ProSet9800 v52.3",
			AGSELS51.PP_	"AGFA_SelectSet5000 v52.3",
			AGSELS71.PP_	"AGFA_SelectSet7000 v52.3",
			CGENERAL.PP_	"Color General",
			GENERAL.PP_	"General",
			NCCPS801.PP_	"Colormate PS80",
			HPIII522.PP_	"HP LaserJet III v2010.118",
			HP_3P522.PP_	"HP LaserJet IIIP v52.2",
			HPPJXL31.PP_	"HP PaintJet XL300 v2011.112",
			IBM17523.PP_	"IBM 4019 17 fonts",
			IB4029A1.PP_	"IBM LaserPrinter 4029 39 fonts",
			LWNTX470.PP_	"LaserWriter II NTX v47.0",
			APLWIIg1.PP_	"LaserWriter IIg v2010.113",
			APTOLLW1.PP_	"LaserWriter Pro 630 v2010.130",
			L300_493.PP_	"Linotronic 300 v49.3",
			LH330__1.PP_	"Linotronic 330-RIP 30 v52.3",
			LH530__1.PP_	"Linotronic 530-RIP 30 v52.3",
			TKPHZR22.PP_	"Phaser II PXi v2011.108",
			TKPHZR32.PP_	"Phaser III PXi v2011.108",
			AMCHR518.PP_	"PRISMA",
			QCS10503.PP_	"QMS ColorScript 100 Model 10",
			QCS20503.PP_	"QMS ColorScript 100 Model 20",
			QMS81470.PP_	"QMS-PS 810",
			N890_470.PP_	"Silentwriter",
			N890X505.PP_	"Silentwriter XL",
			N2090522.PP_	"Silentwriter2 90",
			VT600W_1.PP_	"Varityper VT-600P v48.0"
			}

		HELP
			{
		       	"Select the PostScript printer description (PPD) files that"
			"match the PostScript output devices you will use for"
			"draft and final output. Select only the files you need,"
			"and then click ""OK."""
			}
		}  /*** End select ppds *****/	


	 }
     }


	/**** INI Settings ****/

	WININI
		{
		"Aldus" "PPD4" PPDSDir
		} 

	SET PPDsInst "TRUE"


	}  /*** END of PPD package ***/



PACKAGE AldFilters  "Sample illustrations"  UNSELECTED
{
	/**** Package Initializations *****/

	GETALDDIR AldDir AldusLocation
	CONFIRMDIR FH4Dir
	SET Serialize "TRUE"

	CONCAT FH4Dir "FH4ART" FH4ARTDir
	CONCAT FH4ARTDir "ALDUS" ALDUSDir 
	CONCAT FH4ARTDir "HORNANDE" HORNANDEDir 
        /*** File Subdirectory Assignments *****/
       
	FILES  FH4ARTDir
	
		{
		 COWDEN.FH_
		 GUDE.FH_
		 VIEBAHN.FH_
		 LOMBART.FH_
		 GIOBBI.FH_
		 FESTA.FH_
		}
	
	
	FILES  ALDUSDir
	
		{
		 ALDUS.FH_
		 SKIRT2.TI_
		 CREATURE.TI_
		 DESIGN1.TI_
		 SKIRT3.TI_
		}
	
	
	FILES  HORNANDEDir
	
		{
		 FISHETCH.TI_
		 HORNANDE.FH_
		 ARROWS.TI_
		}


	}  /*** END of ADDITIONS package ***/




PACKAGE LastPREinstall "" SELECTED INVISIBLE
	{
	IF Serialize EQS "TRUE"
		{
        	GETPERSONAL
		}
/*	IF TutorInstalled EQS "TRUE"
		{
        	DISPLAY LaunchTutorial RunTutorVar
		}
*/
	}



PACKAGE LastOninstalls "" SELECTED INVISIBLE
	{

	/***  Stuff to be done after all other ONINSTALL's are completed ***/

	CONCAT WinDir "CONTROL.EXE" WinCtl	

	ONINSTALL
		{

		/* DDE messages for FreeHand entry in Reg database 
		ADDOLEREGKEY "OLE_ROOT" "FreeHandPub"
		SETOLEREGVALUE "FreeHandPub" "open""%1"",0;"
		SETOLEREGVALUE "FreeHandPub" "open""%1"",0;print;close;quit;"
		*/
		IF ExeInstalled EQS "FALSE"
			{
	        	DISPLAY SucNoRead
			}

		IF ExeInstalled EQS "TRUE"
			{
/*			DISPLAY PrintInfo     */
			DISPLAY SucRead 
			DISPLAY MoreInfo
			}

		}  /**** End Oninstall ****/

	}  /***** End LastOninstalls ****/




/****
	Use EPILOGUE only for options which should be run when the
	user clicks the EXIT button from ALDSETUP

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
        DISPLAY RebootReminder

    }
****/
