unit CADThief;

(*  Version 1.0, 1st Jul 1993

    Intercept Control+Alternate+Delete keypresses

    Originally from (not author): Steven Kerr, steven.kerr@almac.co.uk.
    Extensively modified and most of the documentation written by Wizard,
    aka Mikko Hanninen, wizard@archtwr.tower.nullnet.fi. (Comments, bug
    reports, questions etc. welcome.)
    Some parts contributed by Steve Madsen, sjmadsen@nextsrv.cas.muohio.edu
    (thanks also for your help and comments!).

    CADThief is full public domain (distribute freely).

    ----

    To install CADThief use Install_CADThief. To uninstall CADThief
    use UnInstall_CADThief. (Makes sense, doesn't it? :-) Note that
    you do not need unistall CADThief when exiting your program,
    since CADThief does that automatically.
    If you want to install CADThief automatically when the program runs,
    call Install_CADThief from the unit's code part (at the very end of
    the unit).

    CADThief initially sets the Ctrl+Alt+Del handler to No_Handler, which
    doesn't do anything at all. To set your own handler, set the
    CAD_Handler variable to your own handler procedure. This procedure
    must not take any parameters and it must be compiled with the far
    calls switch on (place the compile switch '{$F+}' before the procedure
    declaration line, see No_Handler for example). The procedure must also
    not get any keyboard input, do any file handling, etc., and it should
    be reasonable fast. Keep the handler simple and short!
    If you don't want Ctr+Alt+Del to do anything, you may just leave the
    empty No_Handler procedure as the CAD_Handler. After initialization
    CAD_Handler is not changed by CADThief, so you do not have to reset
    it after unistalling and re-installing CADThief.

    On some machines strange input (control characters etc.) from keyboard
    after Ctrl+Alt+Del has been pressed is probably caused by wrong shift
    state. DOS thinks that the control or alt key is still depressed even
    if it has been released. To fix this, press the (left) control and alt
    key once. (Sorry, software solution wasn't possible. This problem
    is pretty rare.)

    On installation CADThief checks if it is already installed and won't
    install itself a second time. The current state can be checked with
    the CADThief_Installed function.

    And that's it. After installation pressing Ctrl+Alt+Del executes
    the CAD_Handler, which may do anything you want (e.g. set a global
    variable, display a warning, etc.).

*)

interface

uses
  Dos;

procedure Install_CADThief;     {installation procedure}
procedure UnInstall_CADThief;   {uninstallation procedure}
function CADThief_Installed : boolean;
                                {returns true if CADThief is installed}
procedure No_Handler;           {default handler - doesn't do anything}


var
  CAD_Handler : Procedure;      {handler for Ctrl+Alt+Del
                                 - initially set to No_Handler}

{---------------------------------------------------------------------}

implementation

var
  OldInt09,               {variable for saving old int 9 handler}
  OldExitProc : Pointer;  {variable for saving old exit proc}
  KeyStat     : ^Byte;    {pointer to keyboard state}
  Installed   : Boolean;  {installed state}


procedure GoOldInt(OldIntVector : Pointer);

{ Used to execute the old int 9 handler. }

inline($5B/    {POP BX - get segment}
       $58/    {POP AX - get offset}
       $89/    {MOV SP, BP}
       $EC/
       $5D/    {POP BP}
       $07/    {POP ES}
       $1F/    {POP DS}
       $5F/    {POP DI}
       $5E/    {POP SI}
       $5A/    {POP DX}
       $59/    {POP CX}
       $87/    {XCHG SP, BP}
       $EC/
       $87/    {XCHG [BP], BX}
       $5E/
       $00/
       $87/    {XCHG [BP+2], AX}
       $46/
       $02/
       $87/    {XCHG SP, BP}
       $EC/
       $CB);   {RETF}



{$F+}
procedure NewInt09(AX,BX,CX,DX,SI,DI,DS,ES,BP : Word); interrupt;
{$F-}

{ New interrupt 9 handler which checks for Ctrl+Alt+Del. }

var
  i, j        : Integer; {keypress data}
const
  KsDelCode = $53;       {Del key scan code}

begin {NewInt09}

  {TP versions 5.x: use Inline($FA) instead}
  asm CLI end;                          {disable interrupts}

  i := Port[$60];                       {get scan code}

  if ((i and $7F) = KsDelCode) and      {del key?}
     ((KeyStat^ and $0C) = $0C)         {ctrl + alt?}

    then if ((i and $80) = 0)           {key press (not release)?}

      then begin {ctrl+alt+del pressed}
        j := Port[$61];                 {save kbd status}
        Port[$61] := j and $80;         {reset kbd int}
        Port[$61] := j;                 {set original kbd status}
        Port[$20] := $20;               {signal end of interrupt}

        CAD_Handler;                    {execute the handler}

        Port[$20] := $20;               {signal end of interrupt}
      end {ctrl+alt+del pressed}

      else begin {ignore release of del key}
        j := Port[$61];                 {save kbd status}
        Port[$61] := j and $80;         {reset kbd int}
        Port[$61] := j;                 {set original kbd status}
        Port[$20] := $20;               {signal end of interrupt}
      end {ignore release of del key}

    else {other keys}
      GoOldInt(OldInt09);               {execute the old int 9}

  {TP version 5.x: use Inline($FB) instead}
  asm STI end;                          {enable interrupts}

end; {NewInt09}



procedure Install_CADThief;

begin {Install_CADThief}

  if Installed
    then exit;                        {exit if already installed}

  OldExitProc := ExitProc;            {save old exit pointer}
  ExitProc := @UnInstall_CADThief;    {replace with our uninstall, so
                                       CAD_Thief gets uninstalled
                                       when program exits}

  GetIntVec($09, OldInt09);           {save old int 9 vector}
  SetIntVec($09, @NewInt09);          {replace with our new handler,
                                       which checks for ctrl+alt+del}

  Installed := true;                  {set installed flag}

end; {Install_CADThief}


{$F+}
procedure UnInstall_CADThief;
{$F-}
begin {UnInstall_CADThief}

  ExitProc := OldExitProc;            {restore old exit pointer}
  SetIntVec($09,OldInt09);            {restore old int 9 vector}

  Installed := false;                 {set installed flag}

end; {UnInstall_CADThief}



{$F+}
procedure No_Handler;
begin
  {do absolutely nothing}
end; 
{$F-}



function CADThief_Installed : boolean;

{ Check whether CADThief is installed. }

begin
  CADThief_Installed := Installed;
end;



begin {unit CADThief}

  CAD_Handler := No_Handler;          {set default handler}

                                      {set to keyboard status byte}
{$IFDEF VER70}
  KeyStat := Ptr(Seg0040, $17);  { SJM 6/22 -- BP7 protected mode compatible }
{$ELSE}
  KeyStat := Ptr($40, $17);      { For older versions of TP }
{$ENDIF}

  Installed := false;                 {set installed state}

  {Install_CADThief;}                 {uncomment to install CADThief
                                       automatically when program runs}

end. {unit CADThief}

