program cadtest;

{ Program to test the CADThief unit. }

uses
  CRT, CADThief;

var
  CAD_Pressed : Boolean;


{$F+}                                    {far calls switch: on}
procedure CAD_Proc;

{ Example of a CAD_Handler procedure

  Sets the global variable CAD_Pressed to true, displays a message
  and beeps the speaker.
}

var
  x, y : Byte; {cursor position}

begin {CAD_Proc}

  CAD_Pressed := true;                   {set flag}

  x := wherex;
  y := wherey;
  gotoxy(1,1);
  write('[Ctrl+Alt+Del pressed]');       {display message}
  write(#7);                             {beep}
  gotoxy(x,y);

end; {CAD_Proc}
{$F-}                                    {far calls switch: off}


procedure Installed;
{ Displays CADThief state }
begin
  if CADThief_Installed
    then writeln('CADThief is installed.')
    else writeln('CADThief is not installed.');
end;



var
  c    : Char;    {keyboard input variable}
  Done : Boolean; {input loop done flag}
  x, y : Byte;    {cursor position}

begin

  CAD_Pressed := false;
  clrscr;
  gotoxy(1,3);
  
  {Example of installing CADThief}
  
  Install_CADThief;                      {install}
  CAD_Handler := CAD_Proc;               {set handler}
  Installed;
  write('Press a key to continue (Ctrl+Alt+Del executes CAD_Proc)... ');
  repeat until keypressed;
  c := readkey;
  writeln(c);
  writeln;
  if CAD_Pressed
    then begin                           {if CAD was pressed erase
                                          the message}
      x := wherex;
      y := wherey;
      gotoxy(1, 1);
      write('                      ');
      gotoxy(x, y);
    end;

  {Example of unistalling CADThief}

  UnInstall_CADThief;                    {uninstall}
  Installed;
  write('Press a key to continue (Ctrl+Alt+Del will boot)... ');
  repeat until keypressed;
  c := readkey;
  writeln(c);
  writeln;

  {Example of using CADThief to detect Ctrl+Alt+Del inside a program:
   CAD_Proc sets global variable CAD_Pressed to true, which can be
   checked inside a loop.}

  Install_CADThief;                      {install}
  writeln('CADThief reinstalled.');
  writeln;
  write('Type anything (CR exits): ');
  Done := false;
  CAD_Pressed := false;
  repeat
    if keypressed

      then begin                         {read the key}
        c := readkey;
        if ord(c) = 13
          then Done := true
          else write(c);
      end

      else if CAD_Pressed
        then begin
          CAD_Handler := No_Handler;     {disable further Ctrl+Alt+Dels}
          CAD_Pressed := false;          {reset Ctrl+Alt+Del flag}

          x := wherex;
          y := wherey;
          gotoxy(1, 1);
          write('                      ');
          gotoxy(1, 15);
          writeln('Oops, Ctrl+Alt+Del was pressed.');
          write('Do you want to exit the program? ');
          c := readkey;
          if upcase(c) = 'Y'
            then Done := true
            else begin
              gotoxy(1,15);
              writeln('                               ');
              writeln('                                ');
              gotoxy(x,y);
            end;

          CAD_Handler := CAD_Proc;       {re-enable Ctrl+Alt+Dels}
        end;

  until Done;
  writeln;
  writeln;
  writeln('CADThief unistalls itself automatically on exit.');
  writeln;

end.

