{$IFDEF WINDOWS}
  !! ERROR - This unit is not compatible with Windows !!
{$ENDIF}

{*************************************************}
{*              TXTFONT.PAS 1.00                 *}
{*     Copyright (c) 1994 by Thomas Bargholz     *}
{*             All rights reserved               *}
{*************************************************}

{
This unit enables you to change fonts when working in text mode.
It makes it possible to have two fonts working together, thus
giving you access to 512 characters at the same time.
When two fonts are used at the same time, one is selected by
being low intensity, the other by being high intensity.
You can have up to 8 fonts loaded into display memory at the same
time, and switch between them.
This unit also supports the use of font files, that can contain
multible fonts.
TXTFONT requires VGA.

If you have any comments, suggestions or bug reports, please contact me:

e-mail    : tba@m.dia.dk
snail mail: Thomas Bargholz
            Smallegade 20, 3 tv.
            DK-2000 Frederiksberg
            Denmark
}

{$DEFINE DEBUG}

{$IFDEF DEBUG}
  {$I-,D+,L+,Y+,S+,R+,V+,B+}
{$ELSE}
  {$I-,D-,L-,Y-,S-,R-,V-,B-}
{$ENDIF}

Unit TxtFont;

Interface

Const
  FontSize = 16*256;         {The size in bytes of one font}

Type
  PFont = ^TFont;                      {Pointer to a font}
  TFont = Array[0..FontSize] Of Byte;  {1 font = 256 characters}
  PCharacter = ^TCharacter;            {Pointer to a character}
  TCharacter = Array[0..15] Of Byte;   {1 character = 16 bytes}

Var
  CurrentFont : PFont;       {Holds font after call to GetFont}

Const                        {Const for the OpenFontFile function}
  txtOpen = 0;
  txtCreate = 1;

Const
  FontSignature = $746E4654; {'TFnt' -> txtFont}
  FontVersion = $0100;       {Version 1.0 (BCD encoded)}

Type
  FontHeader = Record        {Header for a font file}
    Signature : LongInt;     {Signature}
    Version : Word;          {Made by version}
    NoFonts : Word;          {No. of fonts in file}
  End;

Type
  FontFile = File;           {Font file type}

{Functions and procedures in this unit:}

  Function IsVga : Boolean;
    {- Determine if display is VGA}

  Procedure GetFont;
    {- Get current default font (FontNum = 0)}

  Procedure SetDefaultFont;
    {- Reset system font}

  Procedure SetFont(FontNum : Byte; F : PFont);
    {- Set a font in a register}

  Procedure SetCharacter(FontNum : Byte; CharNum : Byte; ChData : PCharacter);
    {- Set a single character in a register}

  Procedure EnableFont(FontNum : Byte);
    {- Enable default font}

  Procedure EnableAltFont(FontNum : Byte);
    {- Enable alternate font}

  Procedure AltWrite(S : String);
    {- Write using alternate font}

  Procedure AltWriteLn(S : String);
    {- WriteLn using alternate font}

  Function OpenFontFile(Var F : FontFile; FileName : String;
                        Method : Byte) : Integer;
    {- Open or create a font file}

  Procedure CloseFontFile(Var F : FontFile);
    {- Close an open font file}

  Function WriteFontFileHeader(Var F : FontFile;
                               Header : FontHeader) : Integer;
    {- Write a header to a font file}

  Function GetFontFileHeader(Var F : FontFile;
                             Var Header : FontHeader) : Integer;
    {- Get the header from a Font file}

  Function WriteFontFile(Var F : FontFile; Fnt : PFont) : Integer;
    {- Write a font to a font file}

  Function GetFontFile(Var F : FontFile; FntNo : Word;
                       Var Fnt : PFont ) : Integer;
    {- Get a specific font from a font file}

Implementation

Uses
  Crt;

Var
  OldAttr : Byte;
  DefaultFont : PFont;       {This variable holds the default font}

Function IsVGA : Boolean; Assembler;
Asm
  Mov AX, $1200              {Set alternate select}
  Mov BL, $36                {Enable refresh - only supported by VGA}
  Int $10
  Mov AH, 0
  Cmp AL, $12                {If AL returns $12, then it's a VGA}
  Jnz @NotVGA
  Inc AH
  @NotVGA:
End;

Procedure GetFont; Assembler;
Asm
  Mov AX, $1130              {Get font information}
  Mov BH, 6                  {VGA 8x16 font (assumed default)}
  Push BP
  Int $10
  Mov DX, BP
  Pop BP
  Mov Word(CurrentFont), DX
  Mov Word(CurrentFont+2), ES
End;

Procedure SetDefaultFont;
Begin
  SetFont(0,DefaultFont);    {Reset the default font}
  EnableFont(0);             {Use default as font set 1}
  EnableAltFont(0);          {Use default as font set 2}
End;

Procedure SetFont(FontNum : Byte; F : PFont);
Begin
  If (FontNum < 0) Or (FontNum > 7) Then Exit;
  Asm
  Mov AX, $1100              {Load user specific font}
  Mov BH, 16                 {16 bytes per character}
  Mov BL, FontNum            {Load into register FontNum}
  Mov CX, 256                {Load 256 characters...}
  Mov DX, 0                  {Starting with character 0}
  Mov ES, Word(F+2)
  Push BP
  Mov BP, Word(F)            {ES:BP points to font}
  Int $10
  Pop BP
  End;
End;

Procedure SetCharacter(FontNum : Byte; CharNum : Byte;
                       ChData : PCharacter);
Begin
  If (FontNum < 0) Or (FontNum > 7) Or
     (CharNum < 0) Or (CharNum > 255) Then Exit;
  Asm
  Mov AX, $1100              {Load user specific font}
  Mov BH, 16                 {16 bytes per character}
  Mov BL, FontNum            {Load as font 0 (default)}
  Mov CX, 1                  {Load 1 character...}
  Mov DX, Word(CharNum)      {no CharNum}
  Mov ES, Word(ChData+2)
  Push BP
  Mov BP, Word(ChData)       {ES:BP points to character data}
  Int $10
  Pop BP
  End;
End;

Procedure EnableFont(FontNum : Byte);
Begin
  Case FontNum Of
    0 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00000000b
            Int $10
          End;
        End;
    1 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00000001b
            Int $10
          End;
        End;
    2 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00000010b
            Int $10
          End;
        End ;
    3 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00000011b
            Int $10
          End;
        End;
    4 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00010000b
            Int $10
          End;
        End;
    5 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00010001b
            Int $10
          End;
        End;
    6 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00010010b
            Int $10
          End;
        End;
    7 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00010011b
            Int $10
          End;
        End;
  End;
End;

Procedure EnableAltFont(FontNum : Byte);
Begin
  Case FontNum Of
    0 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00000000b
            Int $10
          End;
        End;
    1 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00000100b
            Int $10
          End;
        End;
    2 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00001000b
            Int $10
          End;
        End ;
    3 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00001100b
            Int $10
          End;
        End;
    4 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00100000b
            Int $10
          End;
        End;
    5 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00100100b
            Int $10
          End;
        End;
    6 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00101000b
            Int $10
          End;
        End;
    7 : Begin
          Asm
            Mov AX, $1103
            Mov BL, 00101100b
            Int $10
          End;
        End;
  End;
End;

Procedure AltWrite(S : String);
Var
  Attr : Byte;
Begin
  Attr := TextAttr;          {Save current attribute}
  TextAttr := Attr Or $08;   {Enable high entensity}
  Write(S);
  TextAttr := Attr;          {Retore old attribute}
End;

Procedure AltWriteLn(S : String);
Begin
  AltWrite(S);
  WriteLn;
End;

Function OpenFontFile(Var F : FontFile; FileName : String;
                         Method : Byte) : Integer;
Var
  Header : FontHeader;
  I : Integer;
Begin
  Assign(F,FileName);
  If Method = txtOpen Then
  Begin
    Reset(F,1);              {Open an existing file}
    I := IOResult;
  End
  Else
  Begin
    Rewrite(F,1);            {Create a new Font file}
    I := IOResult;
    If I = 0 Then
    Begin
      With Header Do
      Begin
        Signature := FontSignature;
        Version := FontVersion;
        NoFonts := 0;
      End;
      I := WriteFontFileHeader(F,Header);{Write a default header to it}
    End;
  End;
  OpenFontFile := I;
End;

Procedure CloseFontFile(Var F : FontFile);
Begin
  Close(F);
End;

Function WriteFontFileHeader(Var F : FontFile;
                                Header : FontHeader) : Integer;
Begin
  Reset(F,1);
  If IOResult <> 0 Then
  Begin
    WriteFontFileHeader := IOResult;
    Exit;
  End;
  BlockWrite(F,Header,SizeOf(FontHeader));
  WriteFontFileHeader := IOResult;
End;

Function GetFontFileHeader(Var F : FontFile;
                              Var Header : FontHeader) : Integer;
Var
  Read : Word;
Begin
  Reset(F,1);
  BlockRead(F,Header,SizeOf(FontHeader),Read);
  If Read <> SizeOf(FontHeader) Then
  Begin
    GetFontFileHeader := 100;
    Exit;
  End;
  GetFontFileHeader := 0;
End;

Function WriteFontFile(Var F : File; Fnt : PFont) : Integer;
Begin
  Seek(F,FileSize(F));
  If IOResult = 0 Then
    BlockWrite(F,Fnt^,SizeOf(TFont));
  WriteFontFile := IOResult;
End;

Function GetFontFile(Var F : FontFile; FntNo : Word;
                        Var Fnt : PFont ) : Integer;
Var
  Read : Word;
Begin
  Seek(F,FntNo*4097-4089);
  If IOResult <> 0 Then
  Begin
    GetFontFile := IOResult;
    Exit;
  End;
  BlockRead(F,Fnt^,SizeOf(TFont),Read);
  If IOResult <> 0 Then
  Begin
    GetFontFile := IOResult;
    Exit;
  End;
  If Read <> SizeOf(TFont) Then
  Begin
    GetFontFile := 100;
    Exit;
  End;
  GetFontFile := 0;
End;

Procedure GetDefaultFont; Assembler;
Asm
  Mov AX, $1130              {Get font information}
  Mov BH, 6                  {VGA 8x16 font (assumed default)}
  Push BP
  Int $10
  Mov DX, BP
  Pop BP
  Mov Word(DefaultFont), DX  {Default font now stored in variable }
  Mov Word(DefaultFont+2), ES{DefaultFont - Do not alter this font}
End;

Begin
  If IsVGA Then              {If it's a VGA, get the default font}
    GetDefaultFont;
End.