{$IFDEF WINDOWS}
  !! ERROR - This unit is not compatible with Windows !!
{$ENDIF}

{*************************************************}
{*              TXTCOLOR.PAS 1.00                *}
{*     Copyright (c) 1994 by Thomas Bargholz     *}
{*             All rights reserved               *}
{*************************************************}

{
This unit enables you to use palettes when working in text mode.
You can set RGB values for a single color, or for all 16 colors
at one time. This unit also supports the use of palette files,
that can contain multible palettes.
The palette functions can only be used on a VGA display.

If you have any comments, suggestions or bug reports, please contact me:

e-mail    : tba@m.dia.dk
snail mail: Thomas Bargholz
            Smallegade 20, 3 tv.
            DK-2000 Frederiksberg
            Denmark
}

{$DEFINE DEBUG}

{$IFDEF DEBUG}
  {$I-,D+,L+,Y+,S+,R+,V+,B+}
{$ELSE}
  {$I-,D-,L-,Y-,S-,R-,V-,B-}
{$ENDIF}

Unit TxtColor;

Interface

Const                        {Const for the OpenPaletteFile function}
  txtOpen = 0;
  txtCreate = 1;

Const
  PaletteSignature = $6C615054;{'TPal' -> txtPalette}
  PaletteVersion = $0100;    {Version 1.0 (BCD encoded)}

Type
  PaletteHeader = Record     {Header for a palette file}
    Signature : LongInt;     {Signature}
    Version : Word;          {Made by version}
    NoPalettes : Word;       {No. of palettes in file}
  End;

Type
  RGBRec = Record            {Record of RGB values}
    R, G, B: Byte;
  End;

Type
  Palette = Array[0..15] Of RGBRec;{Palette for the textmode 16 colors}

Type
  PaletteFile = File;        {Palette file type}

{Functions and procedures in this unit:}

  Function IsVga : Boolean;
    {- Determine if display is VGA}

  Procedure SetDefaultPalette;
    {- Reset system palette}

  Procedure SetBorderColor(Color : Byte);
    {- Set border color on display}

  Procedure GetBorderColor(Var Color : Byte);
    {- Get the border color on display}

  Procedure GetColor(Color : Byte; Var R, G, B : Byte);
    {- Get RGB value for specific color}

  Procedure SetColor(Color, R, G, B : Byte);
    {- Set RGB value for specific color}

  Procedure GetPalette(Var Pal : Palette);
    {- Get the complete palette}

  Procedure SetPalette(Pal : Palette);
    {- Set the complete palette}

  Function OpenPaletteFile(Var F : PaletteFile; FileName : String;
                           Method : Byte) : Integer;
    {- Open or create a palette file}

  Procedure ClosePaletteFile(Var F : PaletteFile);
    {- Close an open palette file}

  Function WritePaletteFileHeader(Var F : PaletteFile;
                                  Header : PaletteHeader) : Integer;
    {- Write a header to a palette file}

  Function GetPaletteFileHeader(Var F : PaletteFile;
                                Var Header : PaletteHeader) : Integer;
    {- Get the header from a palette file}

  Function WritePaletteFile(Var F : PaletteFile; Pal : Palette) : Integer;
    {- Write a palette to a palette file}

  Function GetPaletteFile(Var F : PaletteFile; PalNo : Word;
                          Var Pal : Palette ) : Integer;
    {- Get a specific palette from a palette file}

Implementation

Var
  DefaultPalette : Palette;  {Default palette, contains the startup palette}
  DefaultBorder : Byte;

Function IsVGA : Boolean; Assembler;
Asm
  Mov AX, $1200              {Set alternate select}
  Mov BL, $36                {Enable refresh - only supported by VGA}
  Int $10
  Mov AH, 0
  Cmp AL, $12                {If AL returns $12, then it's a VGA}
  Jnz @NotVGA
  Inc AH
  @NotVGA:
End;

Procedure SetDefaultPalette;
Begin
  SetPalette(DefaultPalette);
  SetBorderColor(DefaultBorder);
End;

Procedure SetBorderColor(Color : Byte); Assembler;
Asm
  Mov AX, $1001
  Mov BH, Color
  Int $10
End;

Procedure GetBorderColor(Var Color : Byte); Assembler;
Asm
  Mov AX, $1008
  Int $10
  Les DI, Color
  Mov ES:[DI], BH
End;

Procedure GetColor(Color : Byte; Var R, G, B : Byte); Assembler;
Asm
  Mov AX, $1007              {Get register for color}
  Mov BL, Color
  Int $10
  Xor BL, BL
  XChg BH, BL                {Put register in BL}
  Mov AX, $1015              {Get RGB for individual color}
  Int $10
  Les DI, R
  Mov ES:[DI], DH            {Get Red value}
  Les DI, G
  Mov ES:[DI], CH            {Get Green value}
  Les DI, B
  Mov ES:[DI], CL            {Get Blue value}
End;

Procedure SetColor(Color, R, G, B : Byte); Assembler;
Asm
  Mov AX, $1007              {Get register for color}
  Mov BL, Color
  Int $10
  Xor BL, BL
  XChg BH, BL                {Put register in BL}
  Mov AX, $1010              {Set RGB for individual color}
  Mov DH, R
  Mov CH, G
  Mov CL, B
  Int $10
End;

Procedure GetPalette(Var Pal : Palette);
Var
  I : Byte;
Begin
  For I := 0 To 15 Do
    GetColor(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;

Procedure SetPalette(Pal : Palette);
Var
  I : Byte;
Begin
  For I := 0 To 15 Do
    SetColor(I,Pal[I].R,Pal[I].G,Pal[I].B);
End;

Function OpenPaletteFile(Var F : PaletteFile; FileName : String;
                         Method : Byte) : Integer;
Var
  Header : PaletteHeader;
  I : Integer;
Begin
  Assign(F,FileName);
  If Method = txtOpen Then
  Begin
    Reset(F,1);              {Open an existing file}
    I := IOResult;
  End
  Else
  Begin
    Rewrite(F,1);            {Create a new palette file}
    I := IOResult;
    If I = 0 Then
    Begin
      With Header Do
      Begin
        Signature := PaletteSignature;
        Version := PaletteVersion;
        NoPalettes := 0;
      End;
      I := WritePaletteFileHeader(F,Header);{Write a default header to it}
    End;
  End;
  OpenPaletteFile := I;
End;

Procedure ClosePaletteFile(Var F : PaletteFile);
Begin
  Close(F);
End;

Function WritePaletteFileHeader(Var F : PaletteFile;
                                Header : PaletteHeader) : Integer;
Begin
  Reset(F,1);
  If IOResult <> 0 Then
  Begin
    WritePaletteFileHeader := IOResult;
    Exit;
  End;
  BlockWrite(F,Header,SizeOf(PaletteHeader));
  WritePaletteFileHeader := IOResult;
End;

Function GetPaletteFileHeader(Var F : PaletteFile;
                              Var Header : PaletteHeader) : Integer;
Var
  Read : Word;
Begin
  Reset(F,1);
  BlockRead(F,Header,SizeOf(PaletteHeader),Read);
  If Read <> SizeOf(PaletteHeader) Then
  Begin
    GetPaletteFileHeader := 100;
    Exit;
  End;
  GetPaletteFileHeader := 0;
End;

Function WritePaletteFile(Var F : File; Pal : Palette) : Integer;
Begin
  Seek(F,FileSize(F));
  If IOResult = 0 Then
    BlockWrite(F,Pal,SizeOf(Palette));
  WritePaletteFile := IOResult;
End;

Function GetPaletteFile(Var F : PaletteFile; PalNo : Word;
                        Var Pal : Palette ) : Integer;
Var
  Read : Word;
Begin
  Seek(F,PalNo*16-8);
  If IOResult <> 0 Then
  Begin
    GetPaletteFile := IOResult;
    Exit;
  End;
  BlockRead(F,Pal,SizeOf(Palette),Read);
  If IOResult <> 0 Then
  Begin
    GetPaletteFile := IOResult;
    Exit;
  End;
  If Read <> SizeOf(Palette) Then
  Begin
    GetPaletteFile := 100;
    Exit;
  End;
  GetPaletteFile := 0;
End;

Begin
  If IsVGA Then              {If it's VGA, get the default palette}
  Begin
    GetPalette(DefaultPalette);
    GetBorderColor(DefaultBorder);
  End;
End.
