{$I-,D-,L-,Y-,S-,R-,V-,B-}

{*****************************************************}
{*                   EXAMPLE2.PAS                    *}
{*         An example program for txtTOOL 1.00       *}
{*        Copyright (c) 1994 by Thomas Bargholz      *}
{*                All rights reserved                *}
{*****************************************************}

Uses
  Crt,
  TxtFont;

Var
  F : PFont;
  C : PCharacter;
  O : FontFile;
  H : FontHeader;
  N, M : Word;

Procedure BitFlip(Var B : Byte);  {This procedure flips the bits, thus }
Const                             {creaing a mirror image. This was    }
  Flip : Array[0..15] Of Byte = ( {taken directly from Niel Rubenking's}
    0, 8, 4, 12, 2, 10, 6, 14,    {book "Turbo Pascal 6.0 Techniques   }
    1, 9, 5, 13, 3, 11, 7, 15);   {and Utilities".                     }
Begin
  B := (Flip[B And $F]) Shl 4 + Flip[B Shr 4];
End;

Begin
  If Not IsVGA Then               {This requires VGA}
    Halt;

  LowVideo;                       {Maek sure that low intesity id default}

  {- First let's work with the default font:}
  {Never work with the actual default font, but allways make a copy of it}
  GetMem(F, 16*256);              {Allocate memory for a font}
  GetFont;                        {Get a copy of the standard font}
  Move(CurrentFont^, F^, 16*256); {Copy the default font to F}
  For N := 0 To 255 Do
    For M := 0 To 15 Do
      BitFlip(F^[N*16+M]);        {Reverse the bits for mirror writing}
  SetFont(2,F);                   {Install font in VGA memory}
  EnableAltFont(2);               {Enable the alternate font}
  LowVideo;                       {Make sure text is low intesity}
  WriteLn('ABCDEFGHIJKLMNOPQRSTUVWXYZ');    {<-- This is normal}
  AltWriteLn('ABCDEFGHIJKLMNOPQRSTUVWXYZ'); {<-- This is mirrored}
  WriteLn;
  Write('Press ENTER to continue...');
  ReadLn;
  SetDefaultFont;                 {Reset fonts}

  {- Change the appearence of the characters 'A' and 'B':}
  For N := 0 To 15 Do
    C^[N] := 1;                   {A thin line on the far right}
  SetCharacter(0,65,C);           {Set character 65 (A)}
  WriteLn('ABABABABABABABABA'#10#13); {all A's will be changed}
  WriteLn('Press ENTER to continue...');
  ReadLn;
  SetCharacter(0,66,C);           {Set character 66 (B)}
  WriteLn('Press ENTER to continue...');
  ReadLn;
  SetDefaultFont;                 {Reset the font}

  {- Let's save the mirror font in a file:}
  N := OpenFontFile(O, 'MIRROR.FNT', txtCreate); {Create a new font file}
  If N <> 0 Then
    Halt;
  N := WriteFontFile(O, F);       {Write the mirror font to the font file}
  If N <> 0 Then
    Halt;
  FreeMem(F, FontSize);           {Free the memory allocated for the font}
  With H Do                       {Fill the header record}
  Begin
    Signature := FontSignature;
    Version := FontVersion;
    NoFonts := 1;
  End;
  N := WriteFontFileHeader(O, H); {Write the header to the font file}
  CloseFontFile(O);               {Close the font file}

  {- Load a different font from file:}
  N := OpenFontFile(O, 'EXAMPLE.FNT', txtOpen); {Open EXAMPLE.FNT}
  If N <> 0 Then
    Halt;
  N := GetFontFileHeader(O, H);   {Check the header}
  If (N <> 0) Or (H.Signature <> FontSignature) Or
     (H.Version <> FontVersion) Or (H.NoFonts = 0) Then
     Halt;
  GetMem(F, FontSize);            {Allocate memory for the font}
  N := GetFontFile(O, 1, F);      {Read the font from the font file}
  If N <> 0 Then
    Halt;
  CloseFontFile(O);               {Close the font file}
  SetFont(1,F);                   {Install the font in VGA memory - bank 1}
  EnableAltFont(1);               {Enable the alternate font as bank 1}
  WriteLn('This is written with the normal font');
  AltWriteLn('This is written with the alternate font');
  WriteLn('Press ENTER to continue...');
  ReadLn;

  {- Reset font}
  SetDefaultFont;

End.
