{$I-,D-,L-,Y-,S-,R-,V-,B-}

{*****************************************************}
{*                   EXAMPLE1.PAS                    *}
{*         An example program for txtTOOL 1.00       *}
{*        Copyright (c) 1994 by Thomas Bargholz      *}
{*                All rights reserved                *}
{*****************************************************}

Uses
  Crt,
  TxtColor;

Var
  Pal : Palette;
  F : PaletteFile;
  H : PaletteHeader;
  R1, R2, G1, G2, B1, B2 : Byte;
  I, J : Integer;
  Ch : Char;

Begin
  If Not IsVGA Then
    Halt;                          {This requires VGA}

  {- Create a screen using all colors:}
  ClrScr;
  For I := 0 To 15 Do
  Begin
    TextColor(I);
    GotoXY(1,I+4);Write('');
  End;
  TextColor(White);

  {- Change RGB on a single color:}
  GetColor(Blue, R1, G1, B1);      {Get the RGB for Blue}
  R2 := R1; G2 := G1; B2 := B1;    {Save the values}
  While (R1 > 0) Or (B1 > 0) Or (G1 > 0) Do
  Begin                            {Fade out to black...}
    If R1 > 0 Then Dec(R1);
    If G1 > 0 Then Dec(G1);
    If B1 > 0 Then Dec(B1);
    SetColor(Blue, R1, G1, B1);    {Set the new RGB for blue}
    Delay(75);
  End;
  While (R1 < R2) Or (B1 < B2) Or (G1 < G2) Do
  Begin                            {Fade in to blue...}
    If R1 < R2 Then Inc(R1);
    If G1 < G2 Then Inc(G1);
    If B1 < B2 Then Inc(B1);
    SetColor(Blue, R1, G1, B1);    {Set the new RGB for blue}
    Delay(75);
  End;

  {- Load a palette from a file:}
  I := OpenPaletteFile(F, 'EXAMPLE.PAL', txtOpen);{Open a palette file}
  If I <> 0 Then
    Halt;                          {Could not open file}
  I := GetPaletteFileHeader(F, H); {Get the header}
  If I <> 0 Then
    Halt;                          {Could not read header}
  If H.Signature <> PaletteSignature Then
    Halt;                          {Not a palette file}
  Repeat
    For J := 1 To H.NoPalettes Do  {Run through the palettes in the file}
    Begin
      I := GetPaletteFile(F, J, Pal);
      If I <> 0 Then
        Halt;                      {Could not read palette}
      SetPalette(Pal);             {Set the palette}
    End;
    SetDefaultPalette;             {Reset palette}
  Until KeyPressed;                {Stop when a key is pressed}
  Ch := ReadKey;

  {- Reset palette to the default:}
  SetDefaultPalette;

  {- Save the current palette:}
  I := OpenPaletteFile(F, 'DEFAULT.PAL', txtCreate);{Create a palette file}
  If I <> 0 Then
    Halt;                          {Could not create file}
  GetPalette(Pal);                 {Get the current palette}
  I := WritePaletteFile(F, Pal);   {Write the palette to the palette file}
  If I <> 0 Then
    Halt;                          {Could not write to file}
  With H Do
  Begin
    Signature := PaletteSignature; {Use default signature}
    Version := PaletteVersion;     {Use default version}
    NoPalettes := 1;               {One palette in the file}
  End;
  I := WritePaletteFileHeader(F, H);{Write the header to the palette file}
  ClosePaletteFile(F);             {Close the palette file}

End.

