{*****************************************************}
{*                     DEMO.PAS                      *}
{*         An example program for txtTOOL 1.00       *}
{*        Copyright (c) 1994 by Thomas Bargholz      *}
{*                All rights reserved                *}
{*****************************************************}

{.$DEFINE DEBUG}

{$IFDEF DEBUG}
{$I-,D+,L+,Y+,A+,X+,R+,G-}
{$ELSE}
{$I-,D-,L-,Y-,A+,X+,R-,G-}
{$ENDIF}

Uses
  Crt,
  txtFont,
  txtColor;

Var
  Pal1, Pal2, Pal3 : Palette;

Procedure ErrorExit(S : String);
Begin
  WriteLn(S);
  If LastMode <> Co80 Then
    TextMode(LastMode);
  SetDefaultFont;
  SetDefaultPalette;
  SetBorderColor(Black);
  NormVideo;
  Halt;
End;

Procedure LoadFonts;
Var
  F : FontFile;
  Font : PFont;
  H : FontHeader;
  I : Integer;
Begin
  GetMem(Font, FontSize);
  I := OpenFontFile(F, 'DEMO.FNT', txtOpen);
  If I <> 0 Then
    ErrorExit('Could not open font file');
  I := GetFontFileHeader(F, H);
  If I <> 0 Then
    ErrorExit('Could not read from font file');
  If H.Signature <> FontSignature Then
    ErrorExit('Not a valid txtFont font file');
  GetFontFile(F, 1, Font);
  SetFont(1, Font);
  FreeMem(Font, FontSize);
  CloseFontFile(F);
End;

Procedure LoadPalettes;
Var
  F : PaletteFile;
  H : PaletteHeader;
  I : Integer;
Begin
  I := OpenPaletteFile(F, 'DEMO.PAL', txtOpen);
  If I <> 0 Then
    ErrorExit('Could not open palette file');
  I := GetPaletteFileHeader(F, H);
  If I <> 0 Then
    ErrorExit('Could not read from palette file');
  If H.Signature <> PaletteSignature Then
    ErrorExit('Not a valid txtColor palette file');
  GetPaletteFile(F, 1, Pal1);
  GetPaletteFile(F, 2, Pal2);
  GetPaletteFile(F, 3, Pal3);
End;

Function CenterText(S : String) : String;
Var
  L, I : Byte;
Begin
  CenterText := S;
  L := Length(S);
  If L = 0 Then
    Exit;
  If L > 80 Then
    CenterText := Copy(S,1,80)
  Else
  Begin
    For I := 1 To ((80 - L) Div 2) Do
      S := ' ' + S;
    CenterText := S;
  End;
End;


Procedure Page01;
Var
  S : String;
Begin
  SetPalette(Pal1);
  EnableAltFont(1);
  TextBackground(Green);
  TextColor(Black);
  ClrScr;
  SetBorderColor(Red);
  S := CenterText('Brighten up your text mode applications with');
  WriteLn(#13#10#10+S+#10#13);
  TextColor(Blue);
  WriteLn('                                         ');
  WriteLn('                                      ');
  WriteLn('                                              ');
  WriteLn('                                               ');
  WriteLn('                                              ');
  WriteLn('                                         ');
  TextColor(Black);
  Write('                      ');
  AltWrite(#70#71#72#73#74#75#76#77#78#255#100#255#79#80#80#81);
  AltWriteLn(#255#82#73#255#83#77#71#84#85#86#255#87#85#74#76#77#71#88#89);
  Write(#10#13'          txtTOOL is a Turbo Pascal 6.0+ library for 80x25 ');
  WriteLn('text mode,');
  WriteLn('          that uses the 8x16 VGA font. The library includes source code.');
  WriteLn('          This version of txtTOOL is released as FreeWare.');
  S := CenterText('txtTOOL offers these following text mode features :');
  WriteLn(#10#13+S+#10#13);
  Write('                  ');AltWrite(#202#203);
  WriteLn('  Usage of different fonts');
  Write('                  ');AltWrite(#202#203);
  WriteLn('  Usage of different palettes');
  Write('                  ');AltWrite(#202#203);
  WriteLn('  Visual tools to create fonts and palettes');
  GotoXY(33,25);Write('<press ENTER>');
  ReadLn;
End;

Procedure Page02;
Var
  S : String;
Begin
  TextBackground(7);
  TextColor(Black);
  ClrScr;
  SetBorderColor(Blue);
  S := CenterText('Use the txtFont unit to work with fonts');
  WriteLn(#10#13#10+S+#10#10#13);
  WriteLn('    Drive list with icons:'#10#13);
  Write('    ');
  AltWrite(#194#195#255#255#194#195#255#255#196#197#255#255#196#197#255#255);
  AltWriteLn(#192#193#255#255#192#193#255#255#198#199);
  WriteLn('    A:  B:  C:  D:  F:  G:  H:'#10#13);
  GotoXY(45,6);Write('Dir list with icons:');
  GotoXY(45,8);AltWrite(#211#212);Write('  DOS');
  GotoXY(45,9);AltWrite(#211#212);Write('  WINDOWS');
  GotoXY(45,10);AltWrite(#211#212);Write('  BP');
  GotoXY(45,11);AltWrite(#209#210);Write('  autoexec.bat');
  GotoXY(45,12);AltWrite(#209#210);Write('  config.sys');
  GotoXY(45,13);AltWrite(#209#210);Write('  command.com');
  GotoXY(45,15);WriteLn('Use radiobuttons and checkboxes:');
  GotoXY(45,17);AltWrite(#204#205);Write('  Not selected');
  GotoXY(45,18);AltWrite(#206#207);Write('  Selected');
  GotoXY(45,19);AltWrite(#200#201);Write('  Not checked');
  GotoXY(45,20);AltWrite(#202#203);Write('  Checked');
  GotoXY(5,11);Write('Use symbols in your text:');
  GotoXY(5,13);AltWrite(#100#255#101#255#102#255#103);
  GotoXY(5,15);WriteLn('Use different fonts:');
  GotoXY(5,17);AltWrite(#30#31#32#33#34#35#33);
  GotoXY(5,18);AltWrite(#36#37#38#39#40);
  GotoXY(5,19);AltWrite(#41#42#43#44#45);
  GotoXY(5,20);AltWrite(#46#47#48#49#50#51#52);
  GotoXY(25,17);AltWrite(#53#54#55#56#57#58);
  GotoXY(25,18);AltWrite(#59#60#61#62#62);
  GotoXY(25,19);AltWrite(#63#64#65#66#67);
  GotoXY(25,20);AltWrite(#90#91#92#93#94#95#93#96);
  GotoXY(33,25);Write('<press ENTER>');
  ReadLn;
End;

Procedure Page03;
Var
  S : String;
  I, J : Integer;
Begin
  TextBackground(3);
  TextColor(Blue);
  ClrScr;
  SetBorderColor(Yellow);
  S := CenterText('Use the txtFont unit to create simple animations');
  WriteLn(#10#13#10+S+#10#10#13);
  GotoXY(33,25);Write('<press ENTER>');
  I := 0;
  Repeat
    Inc(I);
    For J := 1 To 3 Do
    Begin
      GotoXY(20*J,10);
      Case I Of
        1 : AltWrite(#110);
        2 : AltWrite(#111);
        3 : AltWrite(#112);
      Else
        AltWrite(#255);
      End;
      GotoXY(20*J,11);
      Case I Of
        3 : AltWrite(#113);
        4 : AltWrite(#110);
        5 : AltWrite(#111);
        6 : AltWrite(#112);
      Else
        AltWrite(#255);
      End;
      GotoXY(20*J,12);
      Case I Of
        6 : AltWrite(#113);
        7 : AltWrite(#110);
        8 : AltWrite(#111);
        9 : AltWrite(#112);
      Else
        AltWrite(#255);
      End;
      GotoXY(20*J,13);
      Case I Of
        9 : AltWrite(#113);
        10 : AltWrite(#110);
        11 : AltWrite(#111);
        12 : AltWrite(#112);
      Else
        AltWrite(#255);
      End;
      GotoXY(20*J,14);
      Case I Of
        12 : AltWrite(#113);
        13 : AltWrite(#110);
        14 : AltWrite(#111);
      Else
        AltWrite(#255);
      End;
      GotoXY(20*J,15);
      If I = 15 Then
        AltWrite(#114)
      Else
        AltWrite(#255);
    End;
    GotoXY(1,20);ClrEol;
    GotoXY(9+I,20);AltWrite(#215#216#217#218#219);
    GotoXY(49+I,20);AltWrite(#215#216#217#218#219);
    GotoXY(46,25);
    Delay(100);
    If I = 15 Then
      I := 0;
  Until KeyPressed;
  ReadLn;
End;

Procedure Page04;
Var
  S : String;
  I, J : Integer;
  R, G, B : Byte;
  NR, NB, NG : Byte;
Begin
  SetDefaultFont;
  SetDefaultPalette;
  GetColor(Red, R, G, B);
  SetColor(Red, 0, 0, 0);
  TextBackground(Red);
  TextColor(7);
  ClrScr;
  SetBorderColor(7);
  NR := 0; NG := 0; NB := 0;
  While (NR <> R) Or (NG <> G) Or (NB <> B) Do
  Begin
    If NR <> R Then Inc(NR);
    If NG <> G Then Inc(NG);
    If NB <> B Then Inc(NB);
    SetColor(Red, NR, NG, NB);
    Delay(50);
  End;
  S := CenterText('Use the txtColor unit to work with colors');
  WriteLn(#10#13#10+S+#10#10#13);
  For I := 0 To 15 Do
  Begin
    TextColor(I);
    GotoXY(1+I*5,10);Write(#219#219#219#219#219);
    GotoXY(1+I*5,11);Write(#219#219#219#219#219);
    GotoXY(1+I*5,12);Write(#219#219#219#219#219);
    GotoXY(1+I*5,13);Write(#219#219#219#219#219);
  End;
  TextColor(7);
  GotoXY(33,25);Write('<press ENTER>');
  Repeat
    SetPalette(Pal1);
    SetPalette(Pal2);
    SetPalette(Pal3);
    SetDefaultPalette;
  Until KeyPressed;
  ReadLn;
End;

Begin
  If Not IsVGA Then
    ErrorExit('This program requires VGA');
  If LastMode <> Co80 Then
    TextMode(Co80);
  CheckSnow := False;
  LoadFonts;
  LoadPalettes;
  Page01;
  Page02;
  Page03;
  Page04;
  TextBackground(Black);
  TextColor(7);
  ClrScr;
  ErrorExit('Goodbye for now!!');
End.