;use up memory by allocating and staying resident
;for memory size testing of various programs
;call as EATMEM kBytesToEat
;
;written 8/7/85 Kim Kokkonen, TurboPower Software
;modified 5/2/87 to use MASM version 4.0

Cseg    segment public para
        assume  cs:Cseg, ds:Cseg, es:Cseg
        org     100H

eat     proc    near

;parse command line to get amount of memory to eat
comentry:
        mov     si,0081H           ;point to command line string
        mov     di,offset amount$  ;and to string storage area
        xor     cx,cx              ;count chars in cx
        cld
getst:  lodsb                      ;get first non-blank
        cmp     al,' '
        je      getst
        cmp     al,13              ;check for end of input
        jne     more
        mov     dx,offset noinp$   ;no parameter specified ==>error
        jmp     short error

more:   inc     cx
        stosb                      ;store the non-blank character
        lodsb                      ;get next char into al
        cmp     al,' '             ;terminate with <space> or <cr>
        je      done
        cmp     al,13
        je      done
        jmp     short more

;convert amount$ to an integer in amount
;cx holds count of chars
done:   mov     al,36
        stosb                      ;put string terminator on amount$
        mov     si,offset amount$
        mov     di,10
        inc     cx
nextc:  dec     cx
        jcxz    eatit              ;exit if all digits used

        mov     ax,amount          ;partial result into ax
        mul     di                 ;multiply by 10 (should all fit in ax)
        mov     amount,ax          ;store ax

        lodsb                      ;next char into al
        cmp     al,30H             ;make sure it's a digit
        jb      baddig
        cmp     al,39H
        ja      baddig
        and     al,0FH             ;convert to digit
        xor     ah,ah
        add     amount,ax          ;add to amount
        jmp     short nextc

;calculate the paragraphs to eat up
eatit:  mov     dx,amount
        cmp     dx,512
        ja      baddig             ;don't eat more than 512k
        push    dx

;show a success message
        mov     dx,offset succ1$
        mov     ah,9
        int     21H
        mov     dx,offset succ2$
        mov     ah,9
        int     21H

;eat up the memory (free with mark and release)
        pop     dx
        mov     cl,6
        shl     dx,cl           ;convert kB to paras
        mov     ax,3100H        ;return code 0
        int     21H             ;exit and remain resident

baddig: mov     dx,offset baddig$

error:  mov     ah,9
        int     21H
        mov     ax,4C01H
        int     21H

eat     endp

succ1$  db      'Eating up '
amount$ db      32,32,32,32                 ;string holding amount of kB
succ2$  db      ' kBytes of RAM space',13,10,36
amount  dw      0                           ;integer holding amount of kb, then paras
noinp$  db      'No parameter specified. Usage: EATMEM kBtoEat',13,10,36
baddig$ db      'Bad number of kB specified',13,10,36

Cseg    ends
        end     ComEntry
