UNIT VTTIO;

{$I DEFINES.INC}

{$DEFINE ShowAll}     {show chars >= #128}

{ if ShowAll is defined then chars >= #128 can be displayed
{ as a block (#254) much as WordPerfect shows non standard
{ characters. This may be a good choice since the vt100 does
{ not support chars above #127
}

{*$DEFINE ShowBlock}   {show chars >= #128 as a block #254}

INTERFACE

USES crt,fileio,comio,vidio,keyio;

procedure VTInit;
procedure ConOut(c : char);

IMPLEMENTATION

TYPE
  chproc = procedure(c : char);

CONST
  term_id_str : string[7] = ^['[?1;2c';   { VT100 id string }
  lansarg = 10;             { Max number of ANSI arguments }
  nansarg : byte = 0;       { Index for ANSI argument list }

VAR
  ansargs : array[0..lansarg-1] of integer; { Room for 10 ANSI arguments }
  lastc   : char;                           { Saved last character }
  ttstate : chproc;


{***************************************************************************}
{***************************************************************************}

{  V T B E L L  --  Do a VT100 style bell }

procedure VTBell;
begin
   sound(880);
   delay(125);
   nosound;
end;

{ T R A N S M I T I D -- Transmit the terminal id to the host }

procedure TransmitId;
var
  i : integer;
begin
  { Transmit each character of string }
  for i := 1 to length(term_id_str) do ttoc(term_id_str[i]);
end;


{ A N S I M O D E S E T  -- Set/Reset ANSI mode   ,  ESC [ P1,,, Pn h/l }

procedure AnsiModeSet(n : integer; mode : boolean);
begin
  case n of
     2 : { Lock/unlock keyboard };
     4 : { Insert/Replace setting } insertmode := mode;
    12 : { Echo } ;
    20 : { New Line mode } newline := mode;
  end
end;


{ E X T M O D E S E T  --  Set/Reset extended mode after ESC [ ? }

procedure ExtModeSet(n : integer; mode : boolean);
begin
  case n of
     1 : { set cursor key mode }          SetCursorKey(mode);
     3 : { Set the screen width }
         if mode then
           SetScreenWidth(132)
         else
           SetScreenWidth(80);
     4 : { Jump/smooth scroll             (not supported) };
     5 : { Set the background attribute } SetBackGround(mode);
     6 : { Set the scrolling origin }     originmode := mode;
     7 : { set the autowrap mode }        autowrap   := mode;
     8 : { Auto repeat on/off             (not supported) } ;
    18 : { Page print terminator          (not supported) } ;
    19 : { Print region                   (not supported) } ;
    25 : { Display/Hide cursor }          SetCursorVisibility(mode);
  end
end;


procedure atescf(c : char); far; forward;


{  A T N R M  --  local routine to process an arbitrary character }

procedure atnrm(c : char); far;
begin
  {$IFDEF ShowAll}
  {$IFDEF ShowBlock}
  if c >= #128 then
    chrwrite('')
  else
  {$ENDIF}  {ShowBlock}
       if c >= #32 then
    chrwrite(c)
  {$ELSE}
  if (c < #128) and (c >= #32) then
    chrwrite(c)
  {$ENDIF}
  else case c of
    ^E : { 5 - Enquire, transmit answer back };
    ^G : { 7 - bell,    Ring terminal bell }
         VTBell;
    ^H : { 8 - back space, cursor to left }
         SetRelCurs( -1, 0 );
    ^I : { 9 - Horizontal tab, cursor to next tab }
          DoTab;
    ^J : { 10 - Line feed, to bol if newline = true }
         begin
           ScrollUp;
           if (newline) then SetCurs(1,0);
         end;
    ^K , { 11 - Vertical tab, index up }
    ^L : { 12 - Form feed, index up }
         ScrollUp;
    ^M : { 13 - Carriage return, to bol }
         SetCurs(1,0);
    ^N : { 14 - Shift Out, Map G1 to current }
         MapCharSet(1);
    ^O : { 15 - Shift In,  Map G0 to current }
         MapCharSet(0);
    ^[ : { Escape }
         ttstate := atescf;       { next state parser is esc follower }
   end
end;


{ C H A R S E T 0 -- Set the current character set for G0 }

procedure SetChar0(c : char); far;
begin
  SetCharSet( 0, c );
  ttstate := atnrm;
end;

{ C H A R S E T 1 -- Set the current character set for G1 }

procedure SetChar1(c : char); far;
begin
  SetCharSet( 1, c );
  ttstate := atnrm;
end;


{ S E T D O U B L E -- Set the current line to double high and/or wide }

procedure SetDouble(c : char); far;
begin
  case c of
    '5' : { Single width }                         ;
    '6' : { Double width }                         ;
    '3' : { Double height/width }                  ;
    '4' : { Bottom half of double height/width }   ;
  end;
  ttstate := atnrm;
end;

{ E X T P A R S E  -- Parse extended mode Set/Reset }

procedure ExtParse(c : char); far;
var
  i : integer;
begin
  case c of
    '0'..'9' : ansargs[nansarg] := (ansargs[nansarg] * 10) + ( ord(c) - ord('0'));
    ';' : {argument seperator}
          begin
            inc(nansarg);
            if nansarg > lansarg then ttstate := atnrm;
          end;

    'h',
    'l' : { Set/Reset Extended ANSI mode }
           begin
             for i := 0 to nansarg do ExtModeSet(ansargs[i],c='h');
             ttstate := atnrm;
           end;
    ^X,
    ^Z  : { Cancel escape sequence }
          ttstate := atnrm;
  else
    ttstate := atnrm;
  end;
end;

{  A N S I P A R S E  --  parse ansi arguments }

procedure AnsiParse(c : char); far;
var
  i,j : integer;

begin
  { c := c and $7F   why? ;}
  case c of
    '0'..'9' : {numerical parameter}
          ansargs[nansarg] := (ansargs[nansarg] * 10) + ( ord(c) - ord('0'));
    ';' : {argument seperator}
          begin
            inc(nansarg);
            if nansarg > lansarg then ttstate := atnrm;
          end;

    'h',
    'l' : { Set/reset ANSI mode }
           begin
             for i := 0 to nansarg do AnsiModeSet(ansargs[i],c='h');
             ttstate := atnrm;
           end;

    'H',  
    'f' : { Address cursor to line and column }
          begin
            i := ansargs[0];
            j := ansargs[1];
            if ( i = 0) then i := 1;
            if ( j = 0) then j := 1;
            SetCurs(j,i);
            ttstate := atnrm;
          end;

    'J' : { Erase screen }
          begin
            if (ansargs[0] = 0) then { from cursur to end of the screen }
              ClearEOS
            else if (ansargs[0] = 1) then { from home position to cursur }
              ClearBOS
            else if (ansargs[0] = 2) then { whole screen }
              ClearScreen;
            ttstate := atnrm;
          end;

    'K' : { Erase Line }
          begin
            if (ansargs[0] = 0) then { from cursur to end of the line }
               ClearEOL
            else if (ansargs[0] = 1) then { start of line to cursur }
               ClearBOL
            else if (ansargs[0] = 2) then begin { whole line }
               ClearBOL;
               ClearEOL;
            end;
            ttstate := atnrm;
          end;

    'm' :  { Select screen attribute }
           begin
             ttstate := atnrm;
             for i := 0 to nansarg do begin
                case ansargs[i] of
                  0 : if (i = 0) then
                        SetVattr( NORMAL )
                      else
                        AddVattr(NORMAL);
                  1 : if (i = 0) then
                        SetVattr( BOLD)
                      else
                        AddVattr(BOLD);
                  4 : if (i = 0) then
                        SetVattr( UNDERLINED )
                      else
                        AddVattr( UNDERLINED );
                  5 : if (i = 0) then
                        SetVattr( BLINK )
                      else
                        AddVattr( BLINK );
                  7 : if (i = 0) then
                        SetVattr( REVERSE )
                      else
                        AddVattr( REVERSE );
                 22 : SubVattr( BOLD );
                 24 : SubVattr( UNDERLINED );
                 25 : SubVattr( BLINK );
                 27 : SubVattr( REVERSE );
                end {case}
             end; {for}
           end;

    '?' : { Extended mode set/reset }
           if (lastc = '[') then
              ttstate := ExtParse
           else
              ttstate := atnrm;

    'r' : { Define scrolling region }
          begin
            SetScroll(ansargs[0],ansargs[1]);
            ttstate := atnrm;
          end;

    'A' : { Move cursor up }
          begin
            if (ansargs[0] = 0) then
              SetRelCurs(0,-1)
            else
              SetRelCurs(0,-ansargs[0]);
            ttstate := atnrm;
          end;

    'B' : { Move cursor down }
          begin
            if (ansargs[0] = 0) then
              SetRelCurs(0,1)
            else
              SetRelCurs(0,ansargs[0]);
            ttstate := atnrm;
          end;

    'C' : { Move cursor right }
          begin
            if (ansargs[0] = 0) then
              SetRelCurs(1,0)
            else
              SetRelCurs(ansargs[0],0);
            ttstate := atnrm;
          end;

    'D' : { Move cursor left }
          begin
            if (ansargs[0] = 0) then
              SetRelCurs(-1,0)
            else
              SetRelCurs(-ansargs[0],0);
            ttstate := atnrm;
          end;

    'g': { Tab stop set/reset }
         begin
           if (ansargs[0] = 0) then
             ClearTabStop
           else if (ansargs[0] = 3) then
             ClearAllTabs;
           ttstate := atnrm;
         end;

    'c' : { Transmit the terminal ID }
          TransmitId;

    ^X,
    ^Z  : { Cancel escape sequence }
          ttstate := atnrm;
  else
    ttstate := atnrm; { unrecognized so ignore }
  end;
end;


{  A T E S C F  --  escape sequence follower }

procedure atescf(c : char);
begin
  case c of
    '[' : { Parse ansi args }
          begin
            fillchar(ansargs,sizeof(ansargs),0);
            nansarg := 0;
            ttstate := AnsiParse;
          end;
    'D' : { Index down }
          begin
            ScrollUp;
            ttstate := atnrm;
          end;

    'E' : { Carriage return/line feed combination }
          begin
            SetCurs(1,0);
            ScrollUp;
            ttstate := atnrm;
          end;

    'M' : { Reverse Index }
          begin
            ScrollDown;
            ttstate := atnrm;
          end;

    'H' : { Set a tab stop }
          begin
            SetTabStop;
            ttstate := atnrm;
          end;

    '7' : { Save cursor description }
          begin
            SaveCursor;
            ttstate := atnrm;
          end;

    '8' : { Restore cursor description }
          begin
            RestoreCursor;
            ttstate := atnrm;
          end;

    '=' :  { Enable application keypad }
           begin
             SetKeyPad(true);
             ttstate := atnrm;
           end;

    '>' :  { Enable numeric keypad }
           begin
             SetKeyPad(false);
             ttstate := atnrm;
           end;

    'c' :  { Reset terminal to power on values }
           begin
             VTInit;
             ttstate := atnrm;
           end;

    '(' :  { Select character set G0 }
           ttstate := SetChar0;

    ')' :  { Select character set G1 }
           ttstate := SetChar1;

    '#' :  { Set double high/wide characters }
           ttstate := SetDouble;

    ^X,
    ^Z  :  { Cancel escape sequence }
           ttstate := atnrm;

    'Z' :  { Transmit the terminal ID }
           begin
             TransmitId;          {VT52 function? }
             ttstate := atnrm;
           end;

    '\' :  ttstate := atnrm;      {could these mean something}
    '<' :  ttstate := atnrm;
    'P' :  ttstate := atnrm;
    '*' :  ttstate := atnrm;
    else
      ttstate := atnrm;     {unknown so quit sequence}
  end;
end;


{  V T I N I T  --   }

procedure VTinit;
begin
  if not InitFileFound then begin  { If there are no saved values for }
    screenwid := 80;               { VT emulation parameters then provid'em }
    newline := false;
    autowrap := false;
    insertmode := false;
    cursorvisible := true;
    reversebackground := false;
    log := false;
  end;
  Setvattr( NORMAL );
  ttstate := atnrm;              { initial output state is normal }
  SetScroll(0,0);
  ClearScreen;
  SetCharSet(0, 'B');
  SetCharSet(1, 'B');
  MapCharSet(0);
  ClearAllTabs;
  InitTabs;
  SetScreenWidth(screenwid);
  SetCursorVisibility(cursorvisible);
  SetBackGround(reversebackground);
  SetCurs(1,1);
  SaveCursor;
  lastc := #0;
end;


{  C O N O U T  --  Put a character to the terminal screen }

procedure ConOut(c : char);
begin
  ttstate(c);
  if log then writelog(c);
  lastc := c;
end;

end.
