UNIT KeyIO;

{$I DEFINES.INC}

INTERFACE

USES crt,dos,fileIO,comIO;

procedure  Keyinit;          { Initialize the keyboard system }
function ConChk : integer;   { Check the keyboard for keystrokes }
function DoKey : integer;

function GetKey : word;

procedure   SetKeyPad(mode : boolean);    { Set the keypad to APPLICATION, NUMERIC }
procedure   SetCursorKey(mode : boolean); { Set the cursor key mode }

IMPLEMENTATION

uses
  vtsetup;

CONST
  ESC      = ^[;     { ASCII ESCape character }
  ESCAPE   = $11B;   { Keyboard ESCape scan code }
  DEL      = #127;   { ASCII DELete character }
  BKSP     = $0E08;  { Keyboard BacKSPace scan code }
  F1       = $3B00;  { Keyboard Function key 1 scan code }
  F2       = $3C00;  { Keyboard Function key 2 scan code }
  F3       = $3D00;  { Keyboard Function key 3 scan code }
  F4       = $3E00;  { Keyboard Function key 4 scan code }
  F5       = $3F00;  { Keyboard Function key 5 scan code }
  F6       = $4000;  { Keyboard Function key 6 scan code }
  F7       = $4100;  { Keyboard Function key 7 scan code }
  F8       = $4200;  { Keyboard Function key 8 scan code }
  F9       = $4300;  { Keyboard Function key 9 scan code }
  F10      = $4400;  { Keyboard Function key 10 scan code }
  UP       = $4800;  { Keyboard Up Arrow scan code }
  DOWN     = $5000;  { Keyboard Down Arrow scan code }
  LEFT     = $4B00;  { Keyboard Left Arrow scan code }
  RIGHT    = $4D00;  { Keyboard Right Arrow scan code }
  K7       = $4737;  { Keyboard Numeric 7 scan code }
  K8       = $4838;  { Keyboard Numeric 8 scan code }
  K9       = $4939;  { Keyboard Numeric 9 scan code }
  KDASH    = $372A;  { Keyboard Numeric Asteric scan code }
  K4       = $4B34;  { Keyboard Numeric 4 scan code }
  K5       = $4C35;  { Keyboard Numeric 5 scan code }
  K6       = $4D36;  { Keyboard Numeric 6 scan code }
  KCOMA    = $4A2D;  { Keyboard Numeric Dash(minus) scan code }
  K1       = $4F31;  { Keyboard Numeric 1 scan code }
  K2       = $5032;  { Keyboard Numeric 2 scan code }
  K3       = $5133;  { Keyboard Numeric 3 scan code }
  KENTR    = $4E2B;  { Keyboard Numeric + (plus) scan code }
  K0       = $5230;  { Keyboard Numeric 0 scan code }
  KDOT     = $532E;  { Keyboard Numeric Period scan code }

CONST
   cursorkey : char = '[';      { Sequence character in cursor key }


{***************************************************************************}
{***************************************************************************}


{ K E Y I N I T -- Initialize the keyboard system }

procedure Keyinit;
begin
  if not InitFileFound then begin
    backspace   := false;  { Backspace interpretation flag }
    keyclick    := false;  { Keyclick on/off flag          }
    applkeypad  := false;  { Application key pad mode flag }
  end;
end;


{  G E T K E Y  --  Return a keyboard scan code }

function GetKey : word;
var
  r : registers;
begin
  r.ah := $0;             { Use function 0 of interrupt $16 }
  intr($16,r);            { to check for waiting keystrokes }
  getKey := r.ax;
  if (keyclick) then begin  { If keyclick flag is set }
    sound(250);             { Turn on low frequency sound }
    delay(5);               { Wait a short time period }
    nosound;;               { Turn off the sound }
  end;
end;



{  C O N C H K  --  Check if any key strokes are waiting, check hot keys }

function ConChk : integer;
var
  setupfunct : procedure;
  r : registers;
  junk : word;
begin
  ConChk := 0;            { assume no key                   }
  r.ah := $1;              { Use function 1 of interrupt $16 }
  intr($16,r);            { to check for waiting keystrokes }
  if (r.flags and $40 <> 0) then
    exit; { If the zero flag is set then no keys }
  case r.ax of
    F5 : setupfunct := TTSetup;
    F6 : setupfunct := VidSetup;
    F7 : setupfunct := KeySetup;
    F8 : setupfunct := VT100Setup;
    F9 : setupfunct := FileSetup;
  else begin
    ConChk := 1;  { If not a Setup key return 1 indicating }
    exit;         { a keystroke is ready }
    end;
  end;
  junk := GetKey;      { Retrieve keystroke }
  setupfunct;  { Call the selected setup function }
end;

(************** ok **********************

function ConChk : integer;    {temporary}
var
  r : registers;
begin
  r.ah := $1;                 { Use function 1 of interrupt $16 }
  intr($16,r);                { to check for waiting keystrokes }
  if (r.flags and $40 <> 0) then
    ConChk := 0
  else
    ConChk := 1;
end;
***********************)


{ S E N D B K S P -- Send a backspace out }

procedure SendBksp;
begin
  if (backspace) then      { If backspace flag is on then }
    ttoc(#8)                { transmit a backspace }
  else
    ttoc(DEL);             { Else transmit a delete }
end;

{ T R A N S N U M K E Y  --  Try and translate key from the Numeric Keypad }

function TransNumKey(key : word) : boolean;
begin
  if applkeypad then begin   { If keypad is not in NUMERIC mode }
    TransNumKey := false;    { then no translation here possible }
    exit;
  end;
  TransNumKey := true;
  case key of
    K7    : { Numeric 7 pressed }      ttoc('7');
    K8    : { Numeric 8 pressed }      ttoc('8');
    K9    : { Numeric 9 pressed }      ttoc('9');
    KDASH : { Numeric Minus pressed }  ttoc('-');
    K4    : { Numeric 4 pressed }      ttoc('4');
    K5    : { Numeric 5 pressed }      ttoc('5');
    K6    : { Numeric 6 pressed }      ttoc('6');
    KCOMA : { Numeric Comma pressed }  ttoc(',');
    K1    : { Numeric 1 pressed }      ttoc('1');
    K2    : { Numeric 2 pressed }      ttoc('2');
    K3    : { Numeric 3 pressed }      ttoc('3');
    K0    : { Numeric 0 pressed }      ttoc('0');
    KDOT  : { Numeric Period pressed } ttoc('.');
    KENTR : { Numeric Enter pressed }  ttoc(#13);
  else
    TransNumKey := false;  {no translation after all}
  end;
end;


{ T R A N S A P P L K E Y  --  Try and translate key from Application Keypad}

function TransApplKey(key : word) : boolean;
var
  tc : char;
begin
  TransApplKey := false;       { then no translation here possible }
  if not applkeypad then exit; { If keypad is not in APPLICATION mode }
  tc := #0;
  case key of
    K7    : { Application 7 pressed }      tc := 'w';
    K8    : { Application 8 pressed }      tc := 'x';
    K9    : { Application 9 pressed }      tc := 'y';
    KDASH : { Application Minus pressed }  tc := 'm';
    K4    : { Application 4 pressed }      tc := 't';
    K5    : { Application 5 pressed }      tc := 's';
    K6    : { Application 6 pressed }      tc := 'v';
    KCOMA : { Application Comma pressed }  tc := 'l';
    K1    : { Application 1 pressed }      tc := 'q';
    K2    : { Application 2 pressed }      tc := 'r';
    K3    : { Application 3 pressed }      tc := 's';
    K0    : { Application 0 pressed }      tc := 'p';
    KDOT  : { Application Period pressed } tc := 'n';
    KENTR : { Application Enter pressed }  tc := 'M';
  end;
  if tc = #0 then exit;
  ttoc(ESC);
  ttoc(CursorKey);
  ttoc(tc);
  TransApplKey := true;       { translation done }
end;


{ T R A N S K E Y  -- translate a scancode into a keystroke sequence }

procedure TransKey(key : word);
begin
  case key of                 { Evaluate this keyboard scan code }
    BKSP : { Backspace pressed }
           SendBksp;
    F1 :   { Function key 1 pressed }
           begin
             ttoc( ESC );
             ttoc( 'P' );
           end;
    F2 :   { Function key 2 pressed }
           begin
             ttoc( ESC );
             ttoc( 'Q' );
           end;
    F3 :   { Function key 3 pressed }
           begin
             ttoc( ESC );
             ttoc( 'R' );
           end;
    F4 :   { Function key 4 pressed }
           begin
             ttoc( ESC );
             ttoc( 'S' );
           end;
    UP :   { Up Arrow pressed }
           begin
             ttoc(ESC);
             ttoc(cursorkey);
             ttoc('A');
           end;
    DOWN : { Down Arrow pressed }
           begin
             ttoc(ESC);
             ttoc(cursorkey);
             ttoc('B');
           end;
    RIGHT: { Right Arrow pressed }
           begin
             ttoc(ESC);
             ttoc(cursorkey);
             ttoc('C');
           end;
    LEFT : { Left Arrow pressed }
           begin
             ttoc(ESC);
             ttoc(cursorkey);
             ttoc('D');
           end;
    { No translation yet, check numeric pad }
    else if TransNumKey(key) then
      exit
    else if TransApplKey(key) then
      exit
    else if hi(key) <> 0 then
      ttoc(chr(lo(key)))  { Still no translation, transmit char }
  end;
end;



{  D O K E Y  --  Retrieve and interpret a keystroke }

function DoKey : integer;
var
  scancode : word;
begin
  scancode := GetKey;;          { Get a keystroke, waits if none ready }
  if (scancode = F10) then      { Check for EXIT character }
    DoKey := -1
  else begin                    { Else translate the pressed key }
    TransKey(scancode);
    DoKey := 0;
  end;
end;

{ S E T K E Y P A D -- Set the keypad translation }

procedure SetKeyPad(mode : boolean);
begin
  { TRUE  sets the keypad to APPLICATION mode}
  { FALSE setq the keypad to NUMERIC mode}
  applkeypad := mode;
end;


{ S E T C U R S O R K E Y -- Set the cursor key mode }

procedure SetCursorKey(mode : boolean);
begin       { This establishes the second character }
                                  { of the cursor keys escape sequence }
   if (mode) then                 { If cursor key mode is requested }
      cursorkey := 'O'            { then set cursor key to 'O' }
   else                           { Else }
      cursorkey := '[';           { use a bracket for escape sequences }
end;

end.
