UNIT Fileio;

{$I DEFINES.INC}

INTERFACE

USES dos;

CONST
  NORMAL     = $7  ;    { Normal video attribute     }
  BOLD       = $8  ;    { Bold video attribute       }
  UNDERLINED = $A  ;    { Underlined video attribute }
  REVERSE    = $70 ;    { Reverse video attribute    }
  BLINK      = $80 ;    { blink video attribute      }

  modestr    : string[80] = ' F5-Communications  F6-Video  F7-Keyboard  F8-VT emulation  F9-File    F10-Exit ';
  setupfile  : string[12] = 'CVT100.SET';  { Filename of setup file }
  logfile    : string[12] = 'CVT100.LOG';  { Filename of log file }


  vidmode       : byte    = 0;      { Screen video mode }
  initfilefound : boolean = false;

  { -- global variables for comio -- see ttinit         }
  {                                                     }
  comport  : byte      = 1;       { COM port            }
  speed    : word      = 2400;    { BAUD rate           }
  parity   : string[5] = 'NONE';  { Parity setting      }
  databits : byte      = 8;       { Number of Data bits }
  stopbits : byte      = 1;       { Number of Stop bits }

  { -- global variables for vidio -- see vidinit    }
  {                                                 }
  forecolor   : byte    =  $07;  { Foreground color }
  backcolor   : byte    =  $00;  { Background color }
  retracemode : boolean = false; { Wait for vsynch  }

  { -- global variables for vttio                   }
  {                                                 }
  originmode        : boolean  = false;  { Origin mode, relative or absolute       }
  insertmode        : boolean  = false;  { Insert mode, off or on                  }
  autowrap          : boolean  = false;  { Automatic wrap mode, off or on          }
  newline           : boolean  = false;  { Newline mode, off or on                 }
  cursorvisible     : boolean  = true;   { Cursor visibility, on or hidden         }
  reversebackground : boolean  = false;  { Reverse background attribute, on or off }
  log               : boolean  = false;  { Flag to indicate status of Log          }
  screenwid         : word     = 80;     { Absolute screen width                   }

  { -- global variables for kbdio                   }
  {                                                 }
  backspace   : boolean  = false;  { Backspace interpretation flag }
  keyclick    : boolean  = false;  { Keyclick on/off flag          }
  applkeypad  : boolean  = false;  { Application key pad mode flag }

procedure Fileinit;               { Initialize the file system }
procedure SaveSetup;              { Save setup information to file }

procedure OpenLogFile;         { Open the logfile }
procedure WriteLog(c : char);  { Write a character to the log file }
procedure FlushLogBuff;        { Flush the log file buffer to disk }
procedure CloseLogFile;        { Close the log file }

procedure badexit(s : string);

IMPLEMENTATION

CONST
   LOGBUFFSIZE = 1024;
   logfileopen   : boolean = false;

VAR
   loghandle : text;
   logbuf    : array[1..LOGBUFFSIZE] of char;


{************************************************************************}
{************************************************************************}


{ F I L E I N I T -- initialize the file system }

procedure Fileinit;
var
  f : file;

  function ReadBytes(var here; count : word) : boolean;
  var
    br : word;
  begin
    {$I-}
    blockread(f,here,count,br);
    ReadBytes := (count = br) and (ioresult = 0);
    {$I+}
  end;

begin
  {$I-}
  assign(f,setupfile);
  reset(f,1);
  if ioresult <> 0 then exit;
  if not ReadBytes(comport,1)
  or not ReadBytes(speed,2)
  or not ReadBytes(parity,6)
  or not ReadBytes(databits,1)
  or not ReadBytes(stopbits,1)
  or not ReadBytes(forecolor,1)
  or not ReadBytes(backcolor,1)
  or not ReadBytes(retracemode,1)
  or not ReadBytes(originmode,1)
  or not ReadBytes(insertmode,1)
  or not ReadBytes(autowrap,1)
  or not ReadBytes(newline,1)
  or not ReadBytes(cursorvisible,1)
  or not ReadBytes(reversebackground,1)
  or not ReadBytes(log,1)
  or not ReadBytes(screenwid,2)
  or not ReadBytes(backspace,1)
  or not ReadBytes(keyclick,1)
  or not ReadBytes(applkeypad,1)
  then
    badexit('IO error reading setup file')
  else begin
    close(f);
    if ioresult <> 0 then
      badexit('File close error on reading setup file')
    else begin
      initfilefound := true;
      if log then OpenLogFile;
    end;
  end;
  {$I+}
end;


{ S A V E S E T U P -- save the setup information }

procedure SaveSetup;
var
  f : file;

  function WriteBytes(var here; count : word) : boolean;
  var
    br : word;
  begin
    {$I-}
    blockwrite(f,here,count,br);
    WriteBytes := (count = br) and (ioresult = 0);
    {$I+}
  end;

begin
  {$I-}
  assign(f,setupfile);
  rewrite(f,1);
  if ioresult <> 0 then exit;
  if not WriteBytes(comport,1)
  or not WriteBytes(speed,2)
  or not WriteBytes(parity,6)
  or not WriteBytes(databits,1)
  or not WriteBytes(stopbits,1)
  or not WriteBytes(forecolor,1)
  or not WriteBytes(backcolor,1)
  or not WriteBytes(retracemode,1)
  or not WriteBytes(originmode,1)
  or not WriteBytes(insertmode,1)
  or not WriteBytes(autowrap,1)
  or not WriteBytes(newline,1)
  or not WriteBytes(cursorvisible,1)
  or not WriteBytes(reversebackground,1)
  or not WriteBytes(log,1)
  or not WriteBytes(screenwid,2)
  or not WriteBytes(backspace,1)
  or not WriteBytes(keyclick,1)
  or not WriteBytes(applkeypad,1)
  then
    badexit('IO error writing setup file')
  else begin
    close(f);
    if ioresult <> 0 then
      badexit('File close error writing setup file')
    else
      initfilefound := true;
  end;
  {$I+}
end;


{ O P E N L O G F I L E -- Open the logfile }

procedure OpenLogFile;
begin
  if logfileopen then exit;       { Ignore if already open }
  { Try and open log file for output }
  {$I-}
  assign(loghandle,logfile);
  setTextBuf(loghandle,logbuf);
  append(loghandle);
  if ioresult <> 0 then rewrite(loghandle);
  if ioresult <> 0 then
    badexit('IO error opening log file for output');
  {$I+}
  logfileopen := true;     { Save Flag indicating log file is open }
end;


{ W R I T E L O G -- Put a char in the logfile buffer, flush if necessary }

procedure WriteLog(c : char);
begin
  if logfileopen then begin
    {$I-}
    write(loghandle,c);
    if ioresult <> 0 then
      badexit('IO error writing to log file');
    {$I+}
  end;
end;

{ F L U S H L O G B U F -- Flush the log buffer to disk }

procedure FlushLogBuff;
begin
end;

{ C L O S E L O G F I L E -- Close the logfile }

procedure CloseLogFile;
begin
  if logfileopen then begin
    FlushLogBuff;                { Flush any remaining characters }
    close(loghandle);            { Try and close the log file }
    if ioresult <> 0 then
      badexit('IO error closing log file');
    logfileopen := false;        { Save Flag indicating log file is closed }
  end;
end;


{ B A D E X I T -- Exit the program displaying a fatal error message }

procedure badexit(s : string);
var
  r : registers;
begin
   if vidmode <> 0 then begin
     r.ax := vidmode and $7F;
     intr($10,r);               {reset the original mode}
   end;
   writeln;
   writeln(s);
   halt(1);                      { Exit with errorlevel 1 }
end;


function HeapFunc(size : word) : integer; far;
begin
  HeapFunc := 1;
end;

begin
  HeapError := @HeapFunc;
end.

