{ ========================================================================= }
{ FastMem.pas v3.2 Copyright (c)1994 Robert Rothenburg Walking-Owl          }
{ ========================================================================= }

{ This software may be used freely for non-commerical purposes, and may be  }
{ distributed widely so long as it is neither modified nor sold for profit. }
{ It is distributed "as it" with no warrantees or guarantees of any kind.   }
{ (In other words, USE AT YOUR OWN RISK.)  All Rights Reserved.             }

{ Please e-mail any questions, comments or bug-reports to the author:       }
{ robert.rothenburg@asb.com or rrothenb@ic.sunysb.edu                       }


{$UNDEF _TURBO5}

unit FastMem;
{$F+}

interface uses Dos;

const
  Cpu86        =  0;     { 8086                         }
  Cpu88        =  4;     { 8088  processor - not used   }
  Cpu186       =  8;     { 80186 processor - not used   }
  Cpu286       = 12;     { 80286 processor              }
  Cpu386       = 16;     { 80386 processor              }
  Cpu486       = 20;     { 80486 processor or later     }


type
  TimeRec = record               { Record used by Fetch & Decode time }
              Minute,
              Hour,
              Hundreth,
              Second:   Byte;
            end;

{ This function initializes the FastMem procedures by identifying the }
{ processor used. If it is not run, FastMem defaults to assuming that }
{ an 8086 processor is present.  Note: running IdentifyCpu multiple   }
{ times in a program may damage the stack frame.                      }

procedure IdentifyCpu;

{ GetCpu returns a value based on the Cpu86..Cpu486 constants of what }
{ the processor (according to IdentifyCpu) is.                        }

function  GetCpu: Word;

{ SetCpu overrides the value determined by IdentifyCpu. Used for dis- }
{ abling or re-enabling 32-bit instructions.                          }

procedure SetCpu(Cpu: Word);

{ MemComp compares two blocks of memory and returns TRUE is the are   }
{ equal, FALSE if not.                                                }

function  MemComp(var Block1, Block2; Size: Word): boolean;

{ MemCopy copies one block of memory to another. The blocks may over- }
{ lap iff Dest is greater than Source.                                }

procedure MemCopy(var Source, Dest; Size: Word);

{ MemFill fills a block of memory with a specified byte.              }

procedure MemFill(var Block; Size: Word; Ch: Byte);

{ GetArg returns an argument from the command line. GetArg(0) returns }
{ the fill pathname of the current program. GetArg(-1) returns the    }
{ full argument string, including padded spaces. Note: GetArg accepts }
{ arguments delimited by double quotes, so that arguments containing  }
{ spaces can be passed. If Num exceeds the no. of arguments, GetArg   }
{ returns a null string.                                              }

function  GetArg(Num: Integer): String;

{ GetVar returns the value of an environment variable, or a null     }
{ string if the variable is not defined.                             }

function  GetVar(S: String): String;

{ DelStr will delete a substring from the main string.               }

procedure DelStr(Main: String; Loc, Len: Word);

{ SubStr returns a substring from the main string.                   }

function  SubStr(Main: String; Loc, Len: Word): String;

{ CatStr concatenates two strings, similar to ConCat                 }

function  CatStr(First, Second: String): String;

{ PosStr returns the position of a substring in the main string.     }

function  PosStr(Sub, Main: String): Word;

{ SpaceOf returns a string of Len spaces.                            }

function  SpaceOf(Len: Word): String;

{ NumStr converts an unsigned long integer to a string.              }

function  NumStr(X: LongInt): String;

{ NumVal converts a numeric string to an unsigned long integer. It   }
{ will ignore invalid characters and stop, returning the value of    }
{ the preceeding number(s).                                          }

function  NumVal(S: String): LongInt;

{ XNumVal works the same as NumVal, however it can handle C-style    }
{ hexidecimal, octal and binary numbers (0xnnn, 0nnn, 0bnnn).        }

function  XNumVal(S: String): LongInt;

{ PascalStr converts ASCIIZ (C-sstyle) string to Pascal string.      }
{ AsciiZ converts the Pascal string (S) to an ASCIIZ string at A;    }
{ also returns a pointer to A.                                       }

function PascalStr(var S): String;
function AsciiZ(var A; S: String): Pointer;

{ SwapLong converts a Motorola-style BigEndian long integer to an    }
{ Intel-style long integer.                                          }

function  SwapLong(X: LongInt): LongInt;

{ NixToDos converts Unix-style date-time stamps (number of seconds   }
{ since midnight, Jan. 1, 1970) to a usable format.                  }

procedure NixToDos( DTR: DateTime; X: LongInt);

{ A substitute for the PackTime procedure: uses 286 instructions if  }
{ applicable. (Also very convenient as a function.)                  }

function PackDate( DTR: DateTime): LongInt;

{ Returns the current date and time in DOS PackTime format.          }

function CurrentDate: LongInt;

{ Fetchtime returns the current system time as the number of 100ths  }
{ of a second since midnight.  Useful for timer functions, since one }
{ needs only subtract the start time from the start time and decode. }

function  FetchTime: LongInt;

{ Decodes times returned by FetchTime.                               }

procedure DecodeTime(var Time: TimeRec; Fetched: LongInt);

implementation

procedure IdentifyCpu;
  external; {$L GetCpu }
function GetCpu: Word;
  external;
procedure SetCpu;
  external;

function SwapLong(X: LongInt): LongInt;
  external; {$L SwapLong }

function NumStr(X: LongInt): String;
  external; {$L NumStr }

function MemComp(var Block1, Block2; size: Word): boolean;
  external; {$L MemComp }

procedure MemCopy(var Source, Dest; Size: Word);
  external; {$L MemCopy }

procedure MemFill(var Block; Size: Word; Ch: Byte);
  external; {$L MemFill }

function SpaceOf(Len: Word): String;
  external; {$L SpaceOf }

procedure NixToDos( DTR: DateTime; X: LongInt);
  external; {$L UnixDate }

function  NumVal(S: String): LongInt;
  external; {$L NumVal }

function  XNumVal(S: String): LongInt;
  external;

function PascalStr(var S): String;
  external; {$L AsciiZ }

function AsciiZ(var A; S: String): Pointer;
  external;

function FetchTime: LongInt;
  external; {$L Timer }

procedure DecodeTime(var Time: TimeRec; Fetched: LongInt);
  external;

function GetArg(Num: Integer): String;
  external; {$L GetArg }

function GetVar(S: String): String;
  external; {$L GetVar }

function  CatStr(First, Second: String): String;
  external; {$L CatStr }

function  PosStr(Sub, Main: String): Word;
  external; {$L PosStr }

function  SubStr(Main: String; Loc, Len: Word): String;
  external; {$L SubStr }

procedure DelStr(Main: String; Loc, Len: Word);
  external; {$L DelStr }

function PackDate( DTR: DateTime): LongInt;
  external; {$L DateTime }

function CurrentDate: LongInt;
  external;

{ ========================================================================= }
{ Some older versions of Turbo Pascal cannot link files intelligently: they }
{ require explicit definition of all PUBLICs defined in the object files.   }
{ ** These procedures are meant to be called by FastMem functions only! **  }
{ ========================================================================= }

{$IFDEF _TURBO5 }
  procedure _Move;  external;        { Move CX bytes from DS:SI to ES:DI  }
  procedure _MoveB; external;        { Move CX bytes, backwards (overlap) }
  procedure _Fill;  external;        { Fill CX bytes at DS:SI             }
  procedure _Comp;  external;        { Compare CX bytes at DS:SI w/ ES:DI }
  procedure _Mult32; external;       { Multiply DX:AX by CX, ret. DX:AX   }
  procedure _Divide32; external;     { Divide DX:AX by CX, mod in CX      }
  procedure _AddMul; external;       { Add to DX:AX, then multiply        }
  procedure _BaseConvert; external;  { Convert base 2, 8 or 16 digits     }
{$ENDIF}

end.

