Program Test;
{ This is the most difficult of the EGOF demo programs to follow. It is the
program I use to test new display objects and filters and does most of the
things needed to find bugs.

  This program shows how to use EGOF to make programs that will look similar
at any resolution. It also shows how you can use the same procedures to use
any (editable) bitmap object. Be they filters, memory maps or screens.

  I've included most of the bells and whistles that I could think of, even if
some are a bit out of place. Some combinations of filters, for example, look
rather ugly. What is important is that they work.

  This program requires a number of PCX files to be in the current directory
to work. (See the constant [Picture] below.) These pictures can be created
by running the program MAKEPIC.PAS
}

{$X+}

Uses
  EGOF,         { Excelent Graphics Object Framework!          }
  VesaU,        { Vesa compatible SVGAs                        }
  VgaU,         { Inferiour But Marketable VGA                 }
  MemoryU,      { Memory resident bitmaps                      }
  FilterU,      { Filter reads and/or writes to bitmaps        }
  PatternU,     { Static patterns                              }
  PalU,         { Palette manipulation objects                 }
  CRT;          { KeyPressed + ReadKey + TextColours           }

Var
  RS   : ScrMapP;       { Real-Screen                                      }
  W,                    { Window onto S                                    }
  C,                    { Clipping Filter                                  }
  S,                    { Screen (as seen by the prog)                     }
  OS   : EBitMapP;      { Used for manipulating the linked list of filters }
 { Notice how RS,S and W are all different views of the screen             }

  Check  : BitMapP;     { Checker pattern used by LockMapP                 }
  TP, VP : EPalP;       { Temporary palette, Real palette                  }

  RTable,               { Tables used by colour remap filter               }
  WTable : Array [0..255] of Byte;
  Locked : Boolean;     { Is part of the screen locked?                    }

  Mode   : Word;        { Display mode                                     }
  Xtra   : PChar;       { Get the extra info from the PCX file             }
  X,Y    : LongInt;     { Multiple use counters                            }
  Tmp    : Word;

Const
  Picture  :Array[Mode320x200..Mode360x480] of String
    = ('FracV.pcx',
       'Frac1.pcx',
       'Frac2.pcx',
       'Frac3.pcx',
       'Frac4.pcx',
       'Frac5.pcx',
       'FracX.pcx',
       'FracY.pcx',
       '',
       '',
       '',
       'FracZ.pcx');


Procedure ECheck (Graphic:Boolean);
{ Chck for errors and if any are found display an error message and halt    }
{ Graphic tells us weather we are in graphics mode. If so we must change to }
{ text mode before destroying the RS object                                 }
Var
  EC :ShortInt;
Begin
  If IsEgofError Then Begin
    If Graphic Then
      RS^.Done;
    Dispose (RS);
    EC := GetEgofError;

    { Write Error message }
    WriteLn ('Error #',EC,' : ',EgofErrorStr[EC],'.');
    If (EC=EWrongCard) And (Mode in [Mode640x400..Mode1280x1024]) Then
      WriteLn (' You may have to load a VESA driver.');
    WriteLn;

    { Write Error message in Icelandic }
    WriteLn ('Villa ',EC,'  : ',EgofErrorIce[EC],'.');
    If (EC=EWrongCard) And (Mode in [Mode640x400..Mode1280x1024]) Then
      WriteLn ('  gtir urft a keyra VESA driver.');
    Repeat Until ReadKey<>#0;
    Halt;
  End;
End;


Procedure Init;
{
  This procedure creates the bitmaps used. It starts by prompting for a modes
to use. Then the "user" is asked to select a number of filters to add.
  Now we only have to create the screen bitmap [RS] and linked list of filters
that ultimately direct their output to the screen. Filter one (F1) writes to
F2 which writes to F3 which in turn writes to F4 and so on until Fn writes to
the screen.
}
Const
  { Names of filters, to show what has been selected }
  FilterName :Array [1..5] of String[20] = ('RemapColO,  ',
                                            'XorOpO,     ',
                                            'LockColO    ',
                                            'LockMapO    ',
                                            'ScaleDownBO,');
Var
  Key1,Key2 :Char;       { Choises in menu 1 and 2                }
  Filters   :BufP;       { Static List of up to 32000 filters!    }
  NoFilters :Integer;    { Number of filters                      }
  Modes     :ModeSet;    { Bitmap of supported modes              }
  Count     :Word;       { Multiple use counter                   }

  Procedure WriteItem (L :Char; Mode:Byte);
  { Write one item in the mode-select menu. [L] is the label and [Mode] is the
    mode being offered }
  Begin
    If Mode in Modes Then   { Is the mode supported? }
      TextColor (White)
    Else TextColor (DarkGray);
    WriteLn (L:3,' - ',ModeRes[Mode].XRes:4, 'x', ModeRes[Mode].YRes);
    TextColor (White);
  End;

Begin
  Randomize;

{ Create an instance of each of the three display-objects used, and use the
  InitModeList constructor to get the bitmap of modes supported by this
  object. Objects initialized with InitModeList can not be used except to get
  the modelist.                                                             }
  RS := New (VgaNSP,InitModeMap);    { Get the non-standard modes + 320x200 }
  Modes := RS^.ModeMap;              { Add them to our bit-map              }
  Dispose (RS,DoneSameMode);
  RS := New (VesaP,InitModeMap);     { Get the VESA modes                   }
  Modes := Modes + RS^.ModeMap;      { Add them to our bit-map              }
  Dispose (RS,DoneSameMode);

  { First select a VgaMapO. Note that the illegal choises are not blocked,
    so we can test the error handling functions                             }
  ClrScr;
  TextColor (White);
  WriteLn ('Select Mode to use:');
  WriteLn;
  WriteItem ('V',Mode320x200);
  WriteLn (' ');
  WriteItem ('X',Mode320x240);
  WriteItem ('Y',Mode320x400);
  WriteItem ('Z',Mode360x480);
  WriteLn (' ');
  WriteItem ('1',Mode640x400);
  WriteItem ('2',Mode640x480);
  WriteItem ('3',Mode800x600);
  WriteItem ('4',Mode1024x768);
  WriteItem ('5',Mode1280x1024);
  WriteLn (' ');
  WriteLn ('  Q -  Quit   ');
  Repeat
    Key1 := UpCase (Crt.ReadKey);
  Until Key1 in ['V','X'..'Z','1'..'5','Q'];
  If Key1='Q' Then Halt;

  NoFilters := 0;           { Start with empty list of filters            }
  GetMem (Filters,32000);   { Static list. We'll create the filters later }
  Locked := False;          { No pixels are locked (yet)                  }

  { Now pick the filters }
  ClrScr;
  WriteLn ('Select Filter to use:');
  WriteLn;
  WriteLn ('  0 -  No more filters');
  WriteLn (' ');
  WriteLn ('  1 -  Remap Colours');
  WriteLn ('  2 -  Xor Writes');
  WriteLn ('  3 -  Lock Colours');
  WriteLn ('  4 -  Lock With Map');
  WriteLn (' ');
  WriteLn ('  Q -  Quit   ');
  WriteLn;
  Window (33,1, 80,25);   { Window for the list of filters        }
  Repeat
    Repeat                             { Get one choise }
      Key2 := UpCase (Crt.ReadKey);
    Until Key2 in ['0'..'4','Q'];
    If Key2='Q' Then Halt;

    { Add filter to list }
    Filters^[NoFilters] := Byte(Key2)-Byte('0');
    Inc (NoFilters);
    If Key2<>'0' Then
      Write (FilterName[Filters^[NoFilters-1]]);

  Until (Key2='0') Or (NoFilters>=32000);  { Sorry, only 32000 filters ;-)  }
  Window (1,1,80,25);
  TextColor (LightGray);
  GoToXY (1,13);

  { Create the objects screen object }
  Case Key1 of
    'V'      : Begin         { IBM VGA }
                 Mode := Mode320x200;
                 RS := New (VgaP,Init);
               End;
    'X'..'Z' : Begin         { IBM Non-standard modes }
                 Case Key1 Of
                   'X' : Mode := Mode320x240;
                   'Y' : Mode := Mode320x400;
                   'Z' : Mode := Mode360x480;
                 End;
                 RS := New(VgaNSP,Init(Mode));
                 RS^.Clear(0);
               End;
    '1'..'5' : Begin         { Vesa compatible modes }
                 Mode := Mode640x400+Byte(Key1)-Byte('1');
                 RS := New(VesaP,Init(Mode));
               End;
  End;
  ECheck(False);     { Any errors going graphic? }

  S := RS;                  { The top bitmap object is the screen }
  If NoFilters>=2 Then      { For every filter (if any) }
    For Count :=  0 To NoFilters-2 Do Begin
    { Save a pointer to the current "screen". This is either the real screen }
    { or the 1st filter. Then the next filter is created using this saved    }
    { pointer as the host. This way we can make a linked list of filters.    }
    { The limit of 32000 is an arbitrary number. We could fill all memory    }
    { with filters and writes would (eventually) end up on the screen        }
      OS := S;
      Case Filters^[Count] of
        1 : Begin        { Remap colours }
              S := New (RemapColP,Init(OS,@RTable,@WTable));
              For X := 0 To 255 Do Begin     { Init the colour remap tables }
                RTable[X] := X Div 4;        { Remap to first 64 colours    }
                WTable[X] := (X*4) Mod 256;  { And back to full 256         }
              End;
            End;
        2 : Begin        { Xor writes }
              S := New (XorP,Init(OS));
            End;
        3 : Begin        { Lock colours }
              Locked := True;
              S := New (LockColP, Init(OS,[010,020,030,040,050,060,070,080,090,100,110,120,130,
                                           140,150,160,170,180,190,200,210,220,230,240,250]));
            End;
        4 : Begin        { Lock With (checker) Map }
              Locked := True;
              With RS^ Do
                Check := New(CheckerP,Init(RealX(40000),RealY(30000), RealX(4000),RealY(4000),0,64));
              S := New(LockMapP,Init(OS,Check,64));
            End;
      End;
      ECheck(False);   { Do we have any errors? }
    End;
  FreeMem (Filters,32000);

  { Make a window onto the "screen" for small tests }
  With S^ Do
    W := New(WinP,Init(S,RealX(10000),RealY(5000),RealX(29999),RealY(24999)));

  TP := New (MemPalP,Init);          { Make temporary palette                }
  VP := New (VgaPalP,InitRead);      { Make palette and read screen colours  }
End;

Procedure TestPCX (M :EBitMapP);
Begin
  GetMem (Xtra,106);        { There is text in some of the PCX files. It is }
  BufP(Xtra)^[0] := 106;    { read into the PChar Xtra                      }

{ VP^.BlackPal (0,255);               { Enable this line to fade from black }
  { Read a PCX file to (0,0). Put the palette in TP and extra info in Xtra }
  S^.ReadPCX (0,0, Picture[Mode], TP, Xtra);
  ECheck (True);
  TP^.MixCol (0,1,255);               { Fix "flaw" in FractInt palette      }
  TP^.FadeTo  (VP, 0, 0,255, 24);     { Fade the PCX palette to the screen  }
  Repeat Until ReadKey<>#0;
End;

Procedure TestPal (FS,WT :Word);
{ Fade-Speed & Wait-Time }
{ Do some palette manipulation gymnastics }

  Procedure ShiftPal;
  { Red becomes old green, green becomes old red and blue becomes old red }
  Var
    T,R,G,B :Byte;
    C :Byte;
  Begin
    For C := 0 To 255 Do
      With TP^ Do Begin
        GetCol (C,R,G,B);
        T := R;
        R := G;
        G := B;
        B := T;
        SetCol (C,R,G,B);
      End;
    TP^.FadeTo (VP, 0, 0,255, FS);
    If WT<>0 Then
      Delay (WT);
  End;

  Procedure SubPal;
  { R := 63-R }
  Var
    R,G,B :Byte;
    C :Byte;
  Begin
    For C := 0 To 255 Do With TP^ Do
      Begin
        GetCol (C,R,G,B);
        R := 63-R;
        G := 63-G;
        B := 63-B;
        SetCol (C,R,G,B);
      End;
    TP^.FadeTo (VP, 0, 0,255, FS);
    If WT<>0 Then
      Delay (WT);
  End;

  Procedure SplitPal;
  { Fade part of the palette seperately }
  Begin
    VP^.FadeOut (8,255,FS);
    TP^.FadeTo  (VP, 8, 8,255, FS);
    VP^.FadeOut (0,7, FS);
    TP^.FadeTo  (VP, 0, 0,7, FS);
  End;

  Procedure PcxPal;
  { Read the palette from a PCX file }
  Begin
    TP^.ReadPcx (Picture[Mode],0, 0,255);
    TP^.MixCol (0,1,255);  { Fix "flaw" in FractInt palette }
    TP^.FadeTo  (VP,0, 0,255, FS);
  End;

Begin
  ShiftPal;
  ShiftPal;
  SubPal;
  Repeat Until ReadKey<>#0;

  SplitPal;
  Repeat Until ReadKey<>#0;

  PcxPal;
  Repeat Until ReadKey<>#0;
End;


Procedure TestFade (M :EBitMapP);
{ Fade a checker pattern over M }
Var
  T :BitMapP;
Begin
  With M^ Do Begin
    T := New (CheckerP,Init(XRes,YRes,XRes Div 20,YRes Div 20,0,192));
    FadeMap (0,0, T,0,0,XRes,YRes);
  End;
  Dispose (T,Done);
  Repeat Until ReadKey<>#0;
End;


Procedure TestLine (M:EBitMapP; DoHL,DoVL,DoL :Boolean);
{ DoHL = Do horizontal line     }
{ DoVL = Do vertical line       }
{ DoL  = Do Sierpensky triangle }
Var
  C :Byte;

  Procedure SubTri (Level :Byte; V1X,V1Y, V2X,V2Y ,V3X,V3Y :Real);
  { Draw a Sierpensky triangle vith the vertices (V1X,V1Y) , (V2X,V2Y) and }
  { (V3X,V3Y). This is done by drawing a triangle and then another         }
  { Sierpensky triangle inside it                                          }
  { The real math slows things down slightly...                            }
  Var
    S1X,S1Y,
    S2X,S2Y,
    S3X,S3Y :Real;
  Begin
    If Level=0 Then Exit;      { We have to stop somewhere }

    S1X := (V2X + V3X) * 0.5;  { Calculate the centres of each of the sides }
    S1Y := (V2Y + V3Y) * 0.5;
    S2X := (V1X + V3X) * 0.5;
    S2Y := (V1Y + V3Y) * 0.5;
    S3X := (V1X + V2X) * 0.5;
    S3Y := (V1Y + V2Y) * 0.5;

    M^.Line (Round(S1X), Round(S1Y), Round(S2X), Round(S2Y), C); { Draw the }
    M^.Line (Round(S2X), Round(S2Y), Round(S3X), Round(S3Y), C); { triangle }
    M^.Line (Round(S3X), Round(S3Y), Round(S1X), Round(S1Y), C);

    Dec (Level);  { Next triangle will be one level lower }
    SubTri (Level, V1X,V1Y, S3X,S3Y, S2X,S2Y);  { We now have three }
    SubTri (Level, S3X,S3Y, V2X,V2Y, S1X,S1Y);  { triangles to fill }
    SubTri (Level, S2X,S2Y, S1X,S1Y, V3X,V3Y);
  End;

Begin
  With M^ Do Begin
    If DoHL Then Begin            { Draw horizontal lines }
      For Y := 0 To GetMaxY Do
        HLine (0,Y,GetMaxX+1,Y*255 Div GetMaxY);
      Repeat Until ReadKey<>#0;
    End;

    If DoVL Then Begin            { Draw vertical lines }
      For X := 0 To GetMaxX Do
        VLine (X,0,GetMaxY+1, X*255 Div GetMaxX);
      Repeat Until ReadKey<>#0;
    End;

    If DoL Then Begin             { Draw other lines }
      C := VP^.GetClosest (0,0,0);    { Use black }
      M^.Line (GetCenX,0, GetMaxX,GetMaxY, C);    { Initial triangle }
      M^.Line (GetMaxX,GetMaxY, 0,GetMaxY, C);
      M^.Line (0,GetMaxY, GetCenX,0, C);
      SubTri (Round(Ln(M^.XRes)), GetCenX,0, 0,GetMaxY, GetMaxX,GetMaxY);  { The main "loop" }
      Repeat Until ReadKey<>#0;
    End;
  End;
End;


Procedure TestMem (M :EBitMapP);
{ Draw on a memory bitmap and then copy it repeatedly onto the screen       }
{ It is interesting to se how using diffrent display objects and filters    }
{ changes the relative speeds of the diffrent CopyMap variants              }
Var
  Mem : EBitMapP;
  X   : LongInt;
  Sc  : ScriptP;
Begin
  { Make the bitmap }
  Mem := MakeMemMap (M^.GetMaxX Div 3,M^.GetMaxY Div 3, 2048);
  ECheck (True);

  { Fill it with boxes }
  With Mem^ Do Begin
    For Y := 0 To 15 Do Begin
      FBox(RealX(Y*1200),RealY(Y*920), RealX(39999-Y*1200),RealY(29999-Y*920),Y*16);
       Box(RealX(Y*1200),RealY(Y*920), RealX(39999-Y*1200),RealY(29999-Y*920),(Y+1)*16-1);
    End;
  End;

  { Copy it onto the screen }
  Repeat
    M^.CopyMap (Random(M^.GetMaxX-Mem^.GetMAxX),Random(M^.GetMaxY-Mem^.GetMAxY),
                Mem,0,0,Mem^.GetMaxX,Mem^.GetMaxY);
  Until KeyPressed And (ReadKey<>#00);

  { Draw ellipses on it }
  With Mem^ Do Begin
    Clear (0);
    For X := 16 DownTo 1 Do Begin
      FEllipse(GetCenX,GetCenY, RealX(X*1200),RealY(X*920),X*16-1);
       Ellipse(GetCenX,GetCenY, RealX(X*1200),RealY(X*920),(X-1)*16);
    End;
  End;

  { Copy it transparently to the screen }
  Repeat
    M^.CopyMapT (Random(M^.GetMaxX-Mem^.GetMAxX),Random(M^.GetMaxY-Mem^.GetMaxY),
                 Mem,0,0,Mem^.GetMaxX,Mem^.GetMaxY,0);
  Until KeyPressed And (ReadKey<>#00);

  { Copy it transparently to the screen using a script }

  { One transparent colour. Faster than CopyMapT }
  Sc := MakeScriptT (Mem, 0,0,Mem^.GetMaxX,Mem^.GetMaxY, 0); { Make script }
  Repeat
    M^.CopyMapS (Random(M^.GetMaxX-Sc^.W),Random(M^.GetMaxY-Sc^.H), Mem,Sc);
  Until KeyPressed And (ReadKey<>#00);
  KillScript (Sc);

  { Many transparent colours }
  Sc := MakeScriptS (Mem, 0,0,Mem^.GetMaxX,Mem^.GetMaxY,     { Make script }
         [0,20..40,60..80,100..120,140..160,180..200,220..240]);
  Repeat
    M^.CopyMapS (Random(M^.GetMaxX-Sc^.W),Random(M^.GetMaxY-Sc^.H), Mem,Sc);
  Until KeyPressed And (ReadKey<>#00);
  KillScript (Sc);

  { Lose it }
  Dispose (Mem,Done);
End;


Procedure TestFlood (M:EBitMapP);
{ This is pure torture for the flood-fill algorighm. Expect much better
  results when doing realistic fillings.                                    }
Begin
  If Locked Then      { Sorry, Flood doesn't work on locked maps :( }
    Exit;

  With M^ Do Begin                                 { Make random grid using }
    For X := 0 To GetMaxX Do                       { only a few colours     }
      For Y := 0 To GetMaxY Do
        PutPix (X,Y, Random(8)*32);

  Repeat
    { Fill with the same colours as used in the random area }
    Flood (Random(XRes),Random(YRes),Random(8)*32);
    { Note that the XOR filter will upset this. The colours ultimately      }
    { written to the screen are then not in the set of colours we use for   }
    { filling.                                                              }
    ECheck (True);
  Until KeyPressed And (ReadKey<>#0);
  End;
End;


Procedure TestBox (M:EBitMapP);
{ Just draw some boxes }
Begin
  With M^ Do Begin
    For Y := 0 To 15 Do Begin
      FBox(RealX(Y*1200),RealY(Y*920), RealX(39999-Y*1200),RealY(29999-Y*920),Y*16);
       Box(RealX(Y*1200),RealY(Y*920), RealX(39999-Y*1200),RealY(29999-Y*920),(Y+1)*16-1);
    End;
    Repeat Until ReadKey<>#0;
  End;
End;


Procedure TestCircle (M:EBitMapP);
{ Just draw some Ellipses }
Begin
  With M^ Do Begin
    For X := 16 DownTo 1 Do Begin
      FEllipse(GetCenX,GetCenY, RealX(X*1200),RealY(X*920),X*16-1);
       Ellipse(GetCenX,GetCenY, RealX(X*1200),RealY(X*920),(X-1)*16);
    End;
    Repeat Until ReadKey<>#0;
  End;
End;


Procedure TestCopy (M:EBitMapP);
{ Copy UL quadrant of the screen to the other three }
Var
  SX,SY :Word;
  TX,TY :Word;
Begin
  With M^ Do Begin
    CopyMap (RealX(20000),RealY(00000), M,RealX(00000),RealY(00000),RealX(20000),RealY(15000));
    CopyMap (RealX(00000),RealY(15000), M,RealX(00000),RealY(00000),RealX(20000),RealY(15000));
    CopyMap (RealX(20000),RealY(15000), M,RealX(00000),RealY(00000),RealX(20000),RealY(15000));
    Repeat Until ReadKey<>#0;
  End;
End;


Begin
  Init;                            { Create the objects                     }

  TestPCX (S);     { ReadPcx    }  { Load Background fractal and palette    }
  TestPal (24,100);                { Fade palette back and forth            }
  TestFade (W);    { FadeMap    }  { Pixel fade. No palette manipulation    }
  TestLine (W, True,True,True);    { Do various line things                 }
  TestFlood (W);   { Flood      }  { Flood-fill test                        }
  TestMem (S);     { CopyMapX   }  { Copy from memory to screen             }
  TestBox (W);     { Box/FBox   }  { Draw boxes                             }
  TestCircle (W);  { (F)Ellipse }  { Draw ellipses                          }
  TestCopy (S);    { CopyMap    }  { Copy UL quadrant to the other three    }

  VP^.FadeOut (0,255,24);          { Fade out and kill the palettes         }
  Dispose (VP,Done);
  Dispose (TP,Done);

  Dispose(W,Done);                 { The bitmaps are the next to go...       }
  While Pointer(RS) <> Pointer(S) Do Begin  { While not at the end of list   }
    OS := S;                   { OS is set to the beginning of the list      }
    S  := EFilterP(S)^.HostMap;{ S is set to the 2nd filter in the list      }
    Dispose (OS,Done);         { Remove the 1st filter. S is now the 1st one }
  End;
  Dispose(RS,Done);            { Destroy the last object in the list         }
  {$IFNDEF Ver60}              { Null terminated strings not suported in TP6 }
  If (Xtra[0] = 'H') And (Xtra[1] = 'i') Then          { Write text from PCX }
    WriteLn (Xtra);
  {$ENDIF}
End.
