Program PcxDir;
{
  This program shows how to get information about a PCX file. It Shows the
characteristics of every file given to it as a parameter. It is best used with
4Dos (or 4OS2) like this:
  select pcxdir [*.pcx]
It's not very useful though, since it can take only a limited number of
characters on the command-line. It will still serve as a demo for GetPcxInfo.
}

Uses
  EGOF,
  Crt,
  Dos;

Var
  Pcx  :PcxInfoP;
  C    :Byte;
  X    :Byte;


Function AddExt (FN:PathStr; Ext:ExtStr) :PathStr;
{ Add extension to file if no present }
Var
  Dir  :DirStr;
  Name :NameStr;
  CExt :ExtStr;
Begin
  FSplit (FExpand(FN),Dir,Name,CExt);
  If CExt = '' Then
    AddExt := Dir+Name+'.'+Ext
  Else
    AddExt := Dir+Name+CExt;
End;


Function NameOnly (FN :PathStr) :String;
{ Return only the 8 character file name }
Var
  Dir  :DirStr;
  Name :NameStr;
  Ext  :ExtStr;
Begin
  FSplit (FExpand(FN),Dir,Name,Ext);
  NameOnly := Name;
End;


Begin
  ClrScr;
  WriteLn ('File      Col  XRes   YRes   Pal          File      Col  XRes   YRes   Pal');
  WriteLn ('');
  For C := 1 To ParamCount Do Begin
    Pcx := GetPcxInfo (AddExt(ParamStr(C),'pcx'),nil);

    X := ((C-1) And 1)*43;    { Even files are in the right column }

    GoToXY (X+01,WhereY);
    Write (NameOnly(ParamStr(C)));             { Name }

    GoToXY (X+11,WhereY);

    If IsEgofError Then
      Write (EgofErrorStr[GetEgofError])       { Error }
    Else Begin

      Write (1 Shl Pcx^.BpP);                  { Colours }

      GoToXY (X+15,WhereY);
      Write (Pcx^.XRes:5);                     { X Size }

      GoToXY (X+22,WhereY);
      Write (Pcx^.YRes:5);                     { Y Size }

      Write('   ',YN[Pcx^.Pal]);               { Palette ? }
    End;

    If Odd (C) Then Begin
      GoToXY (38,WhereY);                      { Write the vertical line }
      Write ('');
    End
    Else
      WriteLn;

    Dispose (PCX);                             { Reclaim memory }
  End;
End.