Program ModeInformation;
{
Get a list af available VESA modes and a description of each.
  The output goes to the file in ParamStr(1), or to standard output if not
specified.
  Use as:
    modeinfo > myfile.vmi
}

Uses
  EGOF,         { Excelent Graphics Object Framework!          }
  VesaU,        { Use Vesa compatible SVGAs                    }
  CRT;

Var
  Mode : Word;
  C,                                  { Counter               }
  GMC,                                { Graphics Mode Counter }
  TMC  : Byte;                        { Text Mode Counter     }
  GML  : Array[Byte] of ModeInfo;     { Graphics Mode List    }
  TML  : Array[Byte] of ModeInfo;     { Text Mode List        }
  GMN  : Array[Byte] of Word;         { Graphics Mode Numbers }
  TMN  : Array[Byte] of Word;         { Text Mode Numbers     }
  MI   : ModeInfoP;                   { Mode Information      }
  AI   : AdapterInfoP;                { Adapter Information   }
  F    : Text;                        { Standard Output       }


Procedure GetInfo;
{ Get the information and save it in an array }
Begin
  AI := GetAdapterInfo;
  GMC := 0;
  TMC := 0;
  C := 0;
  While AI^.ModeSup^[C]<>$FFFF Do Begin
    Mode := AI^.ModeSup^[C];
    MI := GetModeInfo (Mode);
    If (MI^.ModeAttr And 1)=1 Then Begin              { If mode is supported }
      If (MI^.ModeAttr Shr 4 And 1)=1 Then Begin
        GML[GMC] := MI^;
        GMN[GMC] := Mode;
        Inc (GMC);
      End
      Else Begin                                      { If graphics mode     }
        TML[TMC] := MI^;
        TMN[TMC] := Mode;
        Inc (TMC);
      End;
    End;
    Dispose (MI);
    Inc (C);
  End;
End;


Function N2S (N:LongInt; L:Byte) :String;
{ Word to String }
Var
  S :String;
Begin
  S := '';
  Str (N,S);
  While Length(S)<L Do
    S := S + ' ';
  N2S := S;
End;

Function Big (S:String; L:Byte) :String;
{ Make the string al teast [L] characters long }
Var
  C :Byte;
Begin
  While Length(S)<L Do
    S := S+' ';
  Big := S;
End;


Procedure Top;
{ Top of the table }
Begin
  Write (F,'');
  For C := 0 to GMC-2 Do
    Write (F,'');
  Write (F,'Ŀ');
  WriteLn (F);
End;


Procedure Bot;
{ Bottom of the table }
Begin
  Write (F,'');
  For C := 0 to GMC-2 Do
    Write (F,'');
  Write (F,'');
  WriteLn (F);
End;


Procedure PutInfoG;
{ Write list of graphics modes }
Begin
  Assign (F,ParamStr(1));
  ReWrite (F);
  If IOResult<>0 Then Begin
    WriteLn ('File Error!');
    Halt;
  End;

  WriteLn (F,'Mode Information');
  Top;

  Write (F,'Mode Number          ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,HexStr(GMN[C],3),'         ');
  WriteLn (F);

  Write (F,'Mode Supported       ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,YN[Odd(ModeAttr Shr 0)],'          ');
  WriteLn (F);

  Write (F,'Optional Info block  ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,YN[Odd(ModeAttr Shr 1)],'          ');
  WriteLn (F);

  Write (F,'BIOS text functions  ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,YN[Odd(ModeAttr Shr 2)],'          ');
  WriteLn (F);

  Write (F,'Colour mode          ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,YN[Odd(ModeAttr Shr 3)],'          ');
  WriteLn (F);

  Write (F,'Graphics mode        ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,YN[Odd(ModeAttr Shr 4)],'          ');
  WriteLn (F);

  Write (F,'Bytes per scanline   ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,N2S(BPL,4),'         ');
  WriteLn (F);

  Bot;
  WriteLn (F,'Extended information');
  Top;

  Write (F,'Resolution           ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      If (ModeAttr Shr 1 And 1) = 1 Then
        Write (F,Big(N2S(XRes,1)+'x'+N2S(YRes,1),9),'    ')
      Else Write (F,' ':14);
  WriteLn (F);

  Write (F,'Colours              ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      If (ModeAttr Shr 1 And 1) = 1 Then
        Write (F,N2S(1 Shl BPP,3),'          ')
      Else Write (F,' ':14);
  WriteLn (F);

  Write (F,'Memory planes        ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      If (ModeAttr Shr 1 And 1) = 1 Then
        Write (F,N2S(Planes,2),'           ')
      Else Write (F,' ':14);
  WriteLn (F);

  Write (F,'Number of banks      ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      If (ModeAttr Shr 1 And 1) = 1 Then
        Write (F,N2S(NoBanks,2),'           ')
      Else Write (F,' ':14);
  WriteLn (F);

  Write (F,'Memory Model         ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      If (ModeAttr Shr 1 And 1) = 1 Then
        Write (F,N2S(MemMod,2),'           ')
      Else Write (F,' ':14);
  WriteLn (F);

  Write (F,'Bank Size            ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      If (ModeAttr Shr 1 And 1) = 1 Then
        Write (F,Big(N2S(BankSize,1)+' kB',5),'        ')
      Else Write (F,' ':14);
  WriteLn (F);

  Bot;
  WriteLn (F,'Windows');
  Top;

  Write (F,'Window Supported     ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,YN[Odd(WinAAttr Shr 0)],'   ',YN[Odd(WinBAttr Shr 0)],'    ');
  WriteLn (F);

  Write (F,'Writeable            ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,YN[Odd(WinAAttr Shr 1)],'   ',YN[Odd(WinBAttr Shr 1)],'    ');
  WriteLn (F);

  Write (F,'Readable             ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,YN[Odd(WinAAttr Shr 2)],'   ',YN[Odd(WinBAttr Shr 2)],'    ');
  WriteLn (F);

  Write (F,'Segment              ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,HexStr(Seg[0],4),' ',HexStr(Seg[1],4),'  ');
  WriteLn (F);

  Write (F,'Window granularity   ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,N2S(WinGran,3),'kB        ');
  WriteLn (F);

  Write (F,'Window size          ');
  For C := 0 To GMC-1 Do
    With GML[C] Do
      Write (F,N2S(WinSize,3),'kB        ');
  WriteLn (F);
  Bot;

  Close (F);
End;


Begin
  GetInfo;
  PutInfoG;

  Dispose (AI);
End.
