Program MakePic;

{ This program creates the pictures needed for the other programs. It takes }
{ a few minutes with an 80x87, but much longer without, so have patience... }

{$N+}   { Use 80x87 code          }
{$E+}   { Use emulation if needed }
{$I-}
{$X+}

Uses
  EGOF,
  FractalU,
  VgaU,
  VesaU,
  MemoryU,
  PalU,
  CRT;

Var
  Mode :Byte;
  Scr  :EBitMapP;
  Pal  :VgaPalO;
  MPal :MemPalO;
  Man  :MandelbrotO;

Const
  Message  :Array [0..50] Of Char = 'Hi! EGOF v1.1 by Logi Ragnarsson. Please register!'#0;
  Palette  :String = 'Neon.Map';
  Picture  :Array[Mode320x200..Mode360x480] of String =
    ('FracV.pcx',
     'Frac1.pcx',
     'Frac2.pcx',
     'Frac3.pcx',
     'Frac4.pcx',
     'Frac5.pcx',
     'FracX.pcx',
     'FracY.pcx',
     '',
     '',
     '',
     'FracZ.pcx');

Function ModeOK :Boolean;
Begin
  Case Mode Of
    Mode320x200 :
      Scr := New (VgaP,Init);
    Mode640x400..Mode1280x1024 :
      Scr := New (VesaP,Init(Mode));
    Mode320x240..ModeMax :
      Scr := New (VgaNsP,Init(Mode));
  End;
  ModeOK := Not IsEgofError;
End;


Function FileExist (FN:String):Boolean;
{ Does the file [FN] exist? }
Var
  F :File;
Begin
  Assign (F,FN);
  ReSet (F);
  If IoResult = 0 Then Begin
    If FileSize (F)>0 Then Begin
      Close (F);
      FileExist := True;
      Exit;
    End;
    Close(F);
  End;

  FileExist := False;
End;


Begin
  ClrScr;
  Pal.Init;
  For Mode := Mode320x200 To Mode360x480 Do
    If Picture[Mode]='' Then Begin
      { I don't need to do anything with these modes. Do I? }
    End
    Else
      If Not (FileExist (Picture[Mode])) Then Begin
        If ModeOK Then Begin
          Scr^.Clear (16);
          Pal.ReadMap (Palette,0,0,255);
          Man.Init (ModeRes[Mode].XRes, ModeRes[Mode].YRes, 64);
          Man.SetPixRatio (ModeRes[Mode].XRes/ModeRes[Mode].YRes * 3/4);
          Man.ShowOn (Scr,0,0);
          Man.Done;
          Scr^.WritePcx (Picture[Mode], 0,0, Scr^.XRes, Scr^.YRes, @Pal, @Message, 50);
          Dispose (Scr,Done);
        End

        Else Begin
          WriteLn ('The ',ModeRes[Mode].XRes,' by ',ModeRes[Mode].YRes,' pixel mode is not accessible');
          If (Mode In [Mode640x400..Mode1280x1024]) And (GetEgofError=EWrongCard) Then
            WriteLn ('You may have to load a VESA driver');
          Delay (250);
        End;

        While Keypressed Do
          Case ReadKey of
            #0  : ReadKey;   { Get rid of extended keys  }
            #27 : Halt;      { Quit if Escape is pressed }
          End;
      End
      Else Begin
        WriteLn (Picture[Mode],' already exists');
        Delay (250);
      End;

  Pal.Done;
End.