Program Sprites;
{ Show how to use the sprite object }
{$B-}
Uses
  CRT,
  EGOF,
  VgaU,
  PalU,
  MemoryU,
  FilterU;

Const
  Happy = False;
  OS2   = True;

Var
  Screen  :VgaO;         { The screen in 320x200 mode        }
  Palette :VgaPalO;
  SFilter :SpriteO;      { The sprite handling filter        }

  WhatSprite :Boolean;
  Sprite  :Array[Boolean] Of SmallMemMapO; { The actual sprite bitmaps }
  Script  :Array[Boolean] Of ScriptP;      { What pixels to copy       }

  X,Y     :Word;
  dX,dY   :ShortInt;

Begin
  Randomize;

  Screen.Init;           { Go graphics           }
  Screen.Clear (15);     { Clear screen to white }
  Palette.Init;          { Create the palette    }

  Sprite[Happy].InitPcx ('Happy.pcc',@Palette,nil);  { Read happy face & make script }
  Script[Happy] := MakeScriptT (@Sprite ,0,0,Sprite[False].XRes,Sprite[False].YRes, 15);
  Sprite[OS2].InitPcx  ('OS2.pcc',nil,nil);         { Read OS/2 logo & make script }
  Script[OS2]  := MakeScriptT (@Sprite ,0,0,Sprite[True].XRes,Sprite[True].YRes, 15);

  SFilter.Init (@Screen,@Sprite[False],Script[False]);
  SFilter.On;

  X := 0;    { Start in upper left corner }
  Y := 0;
  Repeat
    If (X<=0) Then    { If we are at the left edge, move right }
      dX := 1;
    If (Y<=0) Then    { If we are at the top, move down        }
      dY := 1;

    If (X+Sprite[WhatSprite].XRes>Screen.XRes) Then  { If we are at the right edge, move left }
      dX := -1;
    If (Y+Sprite[WhatSprite].YRes>Screen.YRes) Then  { If we are at the bottom, move up }
      dY := -1;

    Inc (X,dX);
    Inc (Y,dY);

    Delay (10);

    If Random (100)=0 Then Begin      { For every 100th frame }
      WhatSprite := Not WhatSprite;   { Change srite }
      SFilter.ChangeSprite (@Sprite[WhatSprite],Script[WhatSprite]); { Tell the sprite object }
    End;

    VRWait;
    SFilter.SetPos (X,Y);   { Move sprite }
  Until KeyPressed And (ReadKey<>#0);

  SFilter.Done;
  Sprite[True].Done;
  KillScript (Script[True]);
  Sprite[False].Done;
  KillScript (Script[False]);
  Screen.Done;
End.