Program ShowCopyMapI;
{ A demo of CopyMapI. Interruptible bit block transfers }
{$B-}
Uses
  EGOF,      { Grandfather unit }
  VgaU,      { VGA unit         }
  MemoryU,   { Memory bitmaps   }
  FractalU,  { Fractal(s)       }
  CRT;

Var
  P :MandelbrotO;  { Good ol' Mandelbrot Set }
  S :VgaO;         { VGA/MCGA 320x200-256    }
  M :BigMemMapO;   { Memory bitmap > 64Kb    }


Procedure ECheck (Graphic:Boolean);
{ Chck for errors and if any are found display an error message and halt.   }
{ Graphic tells us weather we are in graphics mode. If so we must change to }
{ text mode before destroying the S object                                  }
Var
  EC :ShortInt;
Begin
  If IsEgofError Then Begin
    If Graphic Then
      S.Done;
    EC := GetEgofError;

    { Write Error message }
    WriteLn ('Error #',EC,' : ',EgofErrorStr[EC],'.');
    WriteLn;

    { Write Error message in Icelandic }
    WriteLn ('Villa ',EC,'  : ',EgofErrorIce[EC],'.');
    Repeat Until ReadKey<>#0;
    Halt;
  End;
End;


Function WannaStop (Line:Word):Boolean;  Far;
{ Quit if key is pressed }
Begin
  WannaStop := KeyPressed And (ReadKey<>#0);
End;

Function ShowProgress (Line:Word):Boolean;  Far;
{ Show progress and quit if ESC is pressed }
Begin
  GoToXY (1,1);
  WriteLn (Line/(M.YRes-1)*100:3:0,'%');
  ShowProgress := KeyPressed And (ReadKey=#27);  { Stop if ESC pressed }
End;

Begin
  S.Init;                    { Enter graphics mode }
  ECheck (False);            { Error Check         }
  P.Init(S.XRes,S.YRes,128); { Make pattern        }

  With S Do  { Copy pattern to screen. Press any key to stop. }
    CopyMapI (0,0, @P, 0,0,GetMaxX,GetMaxY, WannaStop);
  S.Done;    { Get rid of screen }

  M.Init(S.XRes,S.YRes);     { Make memory map     }
  ECheck (True);             { Error Check         }
  WriteLn ('      - Press escape to cancel');
  With M Do { Copy pattern to memory and show progress }
    CopyMapI (0,0, @P, 0,0,GetMaxX,GetMaxY, ShowProgress);

  M.Done;    { Get rid of memory map }
  P.Done;
End.