
/* Z-Buffer viewer                              */
/* by Tom Hudson for Yost Group, Inc.                           */
/*                                                              */
/* History:                                             */
/* 5/9/94 -- Started coding             */
/* 5/10/94 -- Finished basics     */
/* 6/6/94 -- Compiled release version */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "ixp.h"
#include "trig.h"
#include "keys.h"
#include "dialog.h"

#define HICOLOR

/* Variable definitions */

/************************/

/* Dialog description */

DlgEntry cdialog[]={
	0,"TITLE=\"Autodesk 3D Studio Z-Buffer Viewer\"",
	0,"TITLE=\"Version 1.0\"",
	0,"TITLE=\"Copyright 1994 Tom Hudson.  From Yost Group, Inc.\"",
	0,"TITLE=\"This is a Public Domain IPAS Routine.  Not for Resale\"",
	0,"TITLE=\"\"",
	0,NULL
	};

/* Version test value */

#define VERSION 0x9CF4

typedef struct {
	ulong version;
	} State;

/* the "state" struct MUST start with a "ulong" which is the version#,
	to prevent using data from old versions of this program.
	This verification is performed automatically. */

static State init_state = { VERSION };
static State state = { VERSION };

/* Variables for this process */

static Color_24 *linebuf=NULL;
static Col48 *linebufh=NULL;
static float *zbuf=NULL;
static int ix,iy;
static float zsize;
static int do_z;

FrameParm *fp;
FieldInfo *fld;

/*----------------------------------------------------------------*/

int ClientProcImage(FrameParm *f,FrameInfo *i,FieldInfo *d,int phase,Report *rpt) {
Col48 *hc;
ushort *ha;

/* Store FrameParm for this module */

fp=f;
fld=d;

switch(phase)
 {
 case 0:
  /* If an old 3DS, forget it! */
  if(studio_version()<310)
   {
   error("SEEZ requires 3DS >= 3.1",NULL,NULL,NULL,NULL);
   goto bailout;
   }

  /* If no Z buffer, forget it */
  if(fp->zbuf==(float _far *)NULL)
   {
   error("3DS Z buffer not turned on.",NULL,NULL,NULL,NULL);
   goto bailout;
   }

  zsize=fp->zmax-fp->zmin;
  do_z=(zsize==0.0)?0:1;

sprintf(gp_buffer,"Z min:%.2f max:%.2f size:%.2f",fp->zmin,fp->zmax,zsize);
gfx_debug_print(gp_buffer);

  /* Allocate a line buffer */

  sprintf(gp_buffer,"Image size:%d X %d",fp->dev_width,fp->dev_height);
  switch(fp->image_format)
   {
   case IMG_LOCOLOR:
    if((linebuf=malloc(sizeof(Color_24)*fp->dev_width))==NULL)
     {
     noimage:
     error("No RAM for scan line buffer",gp_buffer,NULL,NULL,NULL);

     bailout:
     free_linebuf();  
     return(0);
     }
    if((zbuf=malloc(fp->dev_width*sizeof(float)))==NULL)
     {
     nozbuf:
     error("No RAM for Z buffer",gp_buffer,NULL,NULL,NULL);
     goto bailout;
     }

    if(do_z)
     {
     for(iy=0; iy<fp->dev_height; ++iy)
      {
      float *zp=zbuf;
      get_zbuf(fp->zbuf,0,iy,zbuf,fp->dev_width);
      for(ix=0; ix<fp->dev_width; ++ix,++zp)
       {
       int brite;
       if(*zp>LARGEFLOAT)
	brite=0;
       else
	brite=(int)((1.0-((zbuf[ix]-fp->zmin)/zsize))*255.0);
       linebuf[ix].r=linebuf[ix].g=linebuf[ix].b=brite;
       }
      put_pixel(fp->outpix,(uchar _far *)NULL,0,iy,linebuf,(uchar *)NULL,fp->dev_width);
      }
     }
    else
     {
     for(ix=0; ix<fp->dev_width; ++ix)
      linebuf[ix].r=linebuf[ix].g=linebuf[ix].b=0;
     for(iy=0; iy<fp->dev_height; ++iy)
      put_pixel(fp->outpix,(uchar _far *)NULL,0,iy,linebuf,
		(uchar *)NULL,fp->dev_width);
     }
    break;
   case IMG_HICOLOR:
    if((linebufh=malloc(sizeof(Col48)*fp->dev_width))==NULL)
     goto noimage;
    if((zbuf=malloc(fp->dev_width*sizeof(float)))==NULL)
     goto nozbuf;

    if(do_z)
     {
     for(iy=0; iy<fp->dev_height; ++iy)
      {
      float *zp=zbuf;
      get_zbuf(fp->zbuf,0,iy,zbuf,fp->dev_width);
      for(ix=0; ix<fp->dev_width; ++ix,++zp)
       {
       int brite;
       if(*zp>LARGEFLOAT)
	brite=0;
       else
	brite=(int)((1.0-((zbuf[ix]-fp->zmin)/zsize))*65535.0);
       linebufh[ix].r=linebufh[ix].g=linebufh[ix].b=brite;
       }
      put_pixelh((Col48 _far *)fp->inpix,(ushort _far *)NULL,0,iy,
		linebufh,(ushort *)NULL,fp->dev_width);
      }
     }
    else
     {
     for(ix=0; ix<fp->dev_width; ++ix)
      linebufh[ix].r=linebufh[ix].g=linebufh[ix].b=0;
     for(iy=0; iy<fp->dev_height; ++iy)
      put_pixelh((Col48 _far *)fp->inpix,(ushort _far *)NULL,0,iy,
		linebufh,(ushort *)NULL,fp->dev_width);
     }
    break;
   }
  free_linebuf();
  return(1);
 }
}

void ClientSetStateVar(int id, void *ptr) {
	OVL o;
	ulong *ul;

	ul=(ulong *)ptr;
	o.ul = *ul;
	switch(id) {
		}
	}

ulong ClientGetStateVar(int id) {
	OVL o;
	switch(id) {
		}
	return(o.ul);
	}

int ClientVarSize(int id) {
	switch(id) {
		default:
			return(1);
		}
	}

char  *ClientGetState(int *size) {
	*size = sizeof(State);
	return((char *)&state);
	}

void ClientResetState() {       
	state = init_state;     
	}

void ClientStartup(EXPbuf *buf) {
	/* allocate data structures, compute lookup tables, etc */
	/* Tell 3DS we're capable of outputting gamma-capable image */
#ifdef HICOLOR
	buf->data.gamma.magic=GAMMA_MAGIC;
#endif
	}

void ClientTerminate(void) { 
	free_linebuf();
	}

DlgEntry *ClientDialog(int n) { 
	return(&cdialog[n]); 
	}

get_pixel(Color_24 _far *map,uchar _far *alph,int x,int y,
	Color_24 *color,uchar *alpha,int pixels)
{
int index=y*fp->dev_width+x;
far_to_near(color,&map[index],sizeof(Color_24)*pixels);
if(alph && alpha)
 far_to_near(alpha,&alph[index],pixels);
}

put_pixel(Color_24 _far *map,uchar _far *alph,int x,int y,
	Color_24 *color,uchar *alpha,int pixels)
{
int index=y*fp->dev_width+x;
near_to_far(&map[index],color,sizeof(Color_24)*pixels);
if(alph && alpha)
 near_to_far(&alph[index],alpha,pixels);
}

get_pixelh(Col48 _far *map,ushort _far *alph,int x,int y,
	Col48 *color,ushort *alpha,int pixels)
{
int index=y*fp->dev_width+x;
far_to_near(color,&map[index],sizeof(Col48)*pixels);
if(alph && alpha)
 far_to_near(alpha,&alph[index],sizeof(ushort)*pixels);
}

put_pixelh(Col48 _far *map,ushort _far *alph,int x,int y,
	Col48 *color,ushort *alpha,int pixels)
{
int index=y*fp->dev_width+x;
near_to_far(&map[index],color,sizeof(Col48)*pixels);
if(alph && alpha)
 near_to_far(&alph[index],alpha,sizeof(ushort)*pixels);
}

get_zbuf(float _far *zin,int x,int y,float *zout,int pixels)
{
int index=y*fp->dev_width+x;
far_to_near(zout,&zin[index],sizeof(float)*pixels);
}

free_linebuf(void)
{
if(linebuf)
 {
 free(linebuf);
 linebuf=NULL;
 }
if(linebufh)
 {
 free(linebufh);
 linebufh=NULL;
 }
if(zbuf)
 {
 free(zbuf);
 zbuf=NULL;
 }
}

char *ClientName(void)
	{
	return("SEEZ.IXP");
	}

