/*-------------------------------[ Vlib ]------------------------------*/
/*                      Text File Viewer Library                       */
/*---------------------------------------------------------------------*/
/* Written by: Jeff Dunlop                                             */
/* Copyright 1991 DB/Soft Publishing Co. All Rights Reserved           */
/*---------------------------------------------------------------------*/

/*--------------------------[ vlibdemo.c ]-----------------------------*/
/*                        Demo shell for VLib                          */
/*---------------------------------------------------------------------*/

#ifdef __TURBOC__
#   include <alloc.h>
#endif
#include <io.h>
#include <fcntl.h>
#include <malloc.h>
#include <stdio.h>

#include "vlib.h"

/*--------------------------------------------------------------*/
/*---------------------------[ main ]---------------------------*/
/*--------------------------------------------------------------*/

int main(int argc, char *argv[])
{
    register int Fore = vlIsMono() ? VL_LIGHTGREY : VL_YELLOW,
        Back = vlIsMono() ? VL_BLACK : VL_BLUE,
        result;

    BORDER bd_info = {{1}, {"Ŀ"}, {VL_YELLOW}, {VL_BLUE}};

    if ( vlIsMono() )
    {
        bd_info.Foreground = VL_LIGHTGREY;
        bd_info.Background = VL_BLACK;
    }

    if ( argc < 2 )
    {
        puts("\nVlibDemo v.1.06v");
        puts("Copyright 1992 DB/Soft Publishing Co.");
        puts("All Rights Reserved");
        puts("\nSyntax: VlibDemo <view file>");

    }
    else
    {
        result = vlFileLister(argv[1], 1, 1, vlGetCols() - 2,
            vlGetRows() - 2, Fore, Back, 0x2000, &bd_info);

        switch ( result )
        {
            case VLIB_DOSERR:
                puts("File not found");
                break;
            case VLIB_ALLOCERR:
                puts("Not enough memory");
                break;
            case 0:
                break;
            default:
                printf("Error %d\n", result);
                break;
        }
    }
    return 0;
}
