/*-------------------------------[ Vlib ]------------------------------*/
/*                      Text File Viewer Library                       */
/*---------------------------------------------------------------------*/
/* Written by: Jeff Dunlop                                             */
/* Copyright 1991 DB/Soft Publishing Co. All Rights Reserved           */
/*---------------------------------------------------------------------*/

/*-------------------------------[ vlib.h ]----------------------------*/
/*             Main header file for VLib file view library             */
/*---------------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/*---------------------------[ defines ]------------------------*/
/*--------------------------------------------------------------*/

#ifndef vlib_h
#   define vlib_h

#define TRUE 1
#define FALSE 0

#define VLIB_ARGERR   1
#define VLIB_DOSERR   2
#define VLIB_ALLOCERR 3

#define VL_BLACK           0
#define VL_BLUE            1
#define VL_GREEN           2
#define VL_CYAN            3
#define VL_RED             4
#define VL_MAGENTA         5
#define VL_BROWN           6
#define VL_LIGHTGREY       7
#define VL_DARKGREY        8
#define VL_LIGHTBLUE       9
#define VL_LIGHTGREEN      10
#define VL_LIGHTCYAN       11
#define VL_LIGHTRED        12
#define VL_LIGHTMAGENTA    13
#define VL_YELLOW          14
#define VL_WHITE           15

/*--------------------------------------------------------------*/
/*-------------------------[ structures ]-----------------------*/
/*--------------------------------------------------------------*/

typedef struct
{
    int b_enable;               /* must be 1 to display border          */
    char b_string[8];           /* Ŀ is a typical example         */
    unsigned char Foreground;
    unsigned char Background;            /* the attribute for the border         */
    unsigned char attr;
} BORDER;

/*--------------------------------------------------------------*/
/*--------------------[ function prototypes ]-------------------*/
/*--------------------------------------------------------------*/

#ifdef __cplusplus
 extern "C" {
#endif
int vlLister(char *file_spec, char *buf, int buflen, int x1, int y1, int x2,
            int y2, unsigned char Foreground, unsigned char Background,
           unsigned buf_size, BORDER *border_info);
int vlBufLister(char *buf, unsigned buflen, int x1, int y1, int x2, int y2,
           unsigned char Foreground, unsigned char Background,
           unsigned buf_size, BORDER *border_info);
int vlFileLister(char *file_spec, int x1, int y1, int x2, int y2,
           unsigned char Foreground, unsigned char Background,
           unsigned buf_size, BORDER *border_info);

int vlGetCols(void);
int vlGetRows(void);
int vlIsDV(void);
int vlIsEgaVga(void);
int vlIsLshift(void);
int vlIsMono(void);
int vlIsRshift(void);
int vlIsShift(void);
unsigned char vlGetVidMode(void);
unsigned vlGetVidbase(void);
void vlCursorOff(void);
void vlCursorSave(void);
void vlCursorRestore(void);

#ifdef __cplusplus
 }
#endif

#endif /* ifdef vlib_h */
