/****************************************************************************/
/* UW_TUT2.C                                                                */
/*                                                                          */
/* NOTE: THIS FILE IS PUBLIC DOMAIN AND MAY BE MODIFIED AND USED AT WILL    */
/*                                                                          */
/* Now, before proceeding further, we will demonstrate UltraWin's powerful  */
/* new debugging facility.  We take the same program but try to write       */
/* text outside of the window's rectangle.  As you will see, UltraWin will  */
/* detect and report this error.  UltraWin will detect virtually any        */
/* pointer or parameter error when using the debug versions of the library. */
/* Once your program is complete, you can rebuild with the normal library   */
/* and increase performance and decrease code size!                         */
/*                                                                          */
/* When building this program, be sure to link in the debug version of the  */
/* library.  For example, for Turbo/Borland C under small model, link in    */
/* UWTSD.LIB.  For Microsoft C small model, link in UWMSD.LIB.              */
/*                                                                          */
/* NOTE: Notice that mv_cs is the function that reports the error. This is  */
/*       due to the fact that wn_plst calls mv_cs.  Also notice that the    */
/*       parameter displayed is the invalid argument, in this case 23!      */
/*       We'll see more of the debugging features as we proceed...          */
/*                                                                          */
/*   WE RECOMMEND THAT YOU EXIT THE PROGRAM WHEN THE ERROR WINDOW OCCURS!   */
/*                                                                          */
/*                                                         Dr. Boyd Gafford */
/*                                                         Kevin Huck       */
/*                                                         EnQue Software   */
/*                                                         08/31/92         */
/****************************************************************************/
#define SOURCE_TRACE 1
#include <ctype.h>
#include "uw.h"                           /* include the necessary headers  */

/*----------------------- global window variables --------------------------*/
WINDOW   Window1;

/*********/
/* ~main */
/*       ********************************************************************/
/*  Show basic debugging facility.                                          */
/****************************************************************************/
int main()
{
  int i;
  WINDOW *wnp;
  
  wnp = &Window1;                         /* set local window pointer       */
  init_video(80, 25);                     /* init video for 80 x 25 screen  */
  wn_create(20, 5, 60, 20, SLD_BDR, WN_POPUP, wnp);        /* create window */
  wn_set(wnp);                            /* display window in screen       */
  wn_plst( CENTERED, 3, "Hello world from UltraWin!", wnp);
  for( i = 0; i < 4; i++ )
  wn_plst( CENTERED, 4, "Hello world from UltraWin!", wnp);
  wn_st( "Hello world from UltraWin!", wnp);
  wn_plst( CENTERED, 23, "Hello world from UltraWin!", wnp); /*write outside*/
  wait_event();                           /* wait for a keystroke           */
  wn_destroy(wnp);                        /* remove the window from screen  */
  end_video();                            /* clean up before we exit        */
  return(1);
}
/*** end of main ***/

/*** END OF FILE ***/
