typedef struct{
    unsigned long bytes;
    unsigned int shandle;
    void far *source;
    unsigned int dhandle;
    void far *destination;
    }XMSMove;

#define XMS_MAJOR_VER(i) (((i) & 0xff00) >> 8)
#define XMS_MINOR_VER(i) (i & 0xff)

int XMS_Init(void);
int XMS_GetVersion(unsigned int *version);
int XMS_RequestHMA(void);
int XMS_ReleaseHMA(void);
int XMS_GlobalEnableA20(void);
int XMS_GlobalDisableA20(void);
int XMS_LocalEnableA20(void);
int XMS_LocalDisableA20(void);
int XMS_QueryA20(int *A20status);
int XMS_QueryFreeExtended(unsigned int *FreeKB,unsigned int *TotalKB);
int XMS_AllocExtended(int *handle,unsigned int kbytes);
int XMS_FreeExtended(int handle);
int XMS_MoveExtended(XMSMove *);
int XMS_LockExtended(int handle,void far **bpt);
int XMS_UnlockExtended(int handle);
int XMS_GetEMBHandleInfo(int handle,int *LockCount,int *FreeHandles,int *BlockSize);
int XMS_ReallocExtended(int handle,unsigned int newsize);
int XMS_RequestUMB(unsigned int para,void far **UMBpt,unsigned int *ActualSize);
int XMS_ReleaseUMB(void far *UMBpt);

#define XMS_HMA (void far *) 0xffff0010

#define XMS_A20_NOT_ENABLED            0
#define XMS_A20_ENABLED                1

#define XMS_NOT_AVAILABLE              0
#define XMS_NOT_INITIALIZED            0
#define XMS_OK                         1
#define XMS_NOT_IMPLEMENTED         0x80
#define XMS_VDISK_PRESENT           0x81
#define XMS_A20_ERROR               0x82
#define XMS_GENERAL_DRIVER_ERROR    0x8e
#define XMS_UNRECOVERABLE_ERROR     0x8f
#define XMS_HMA_NOT_EXIST           0x90
#define XMS_HMA_IN_USE              0x91
#define XMS_HMA_NOT_ALLOCATED       0x93
#define XMS_A20_ALREADY_ENABLED     0x94
#define XMS_ALL_EXTENDED_ALLOCATED  0xa0
#define XMS_NO_MORE_HANDLES         0xa1
#define XMS_INVALID_HANDLE          0xa2
#define XMS_INVALID_SOURCE_HANDLE   0xa3
#define XMS_INVALID_SOURCE_OFFSET   0xa4
#define XMS_INVALID_DEST_HANDLE     0xa5
#define XMS_INVALID_DEST_OFFSET     0xa6
#define XMS_INVALID_LENGTH          0xa7
#define XMS_INVALID_OVERLAP         0xa8
#define XMS_PARITY_ERROR            0xa9
#define XMS_BLOCK_NOT_LOCKED        0xaa
#define XMS_BLOCK_LOCKED            0xab
#define XMS_LOCK_COUNT_OVERFLOW     0xac
#define XMS_LOCK_FAIL               0xad
#define XMS_UMB_SMALL_AVAILABLE     0xb0
#define XMS_UMB_NOT_AVAILABLE       0xb1
#define XMS_UMB_INVALID_SEGMENT     0xb2

