#pragma pack(1)

typedef struct{
    unsigned long bytes;
    char stype;
    unsigned int shandle;
    unsigned int soffset;
    unsigned int sseg;
    char dtype;
    unsigned int dhandle;
    unsigned int doffset;
    unsigned int dseg;
    }EMSMove;

#pragma pack()

typedef struct{
    unsigned int logpage;
    unsigned int phpage;
    }EMSMap;

typedef struct{
    unsigned int handle;
    unsigned int pages;
    }EMSHandle;

#define EMS_MAJOR_VER(i) (((i) & 0x00f0) >> 4)
#define EMS_MINOR_VER(i) ((i) & 0xf)

#define EMS_CONVENTIONAL_MEM    0
#define EMS_EXPANDED_MEM        1

#define EMS_OK                  0
#define EMS_NOT_AVAILABLE       1
#define EMS_INTERNAL_ERROR      0x80
#define EMS_HARDWARE_ERROR      0x81
#define EMS_MANAGER_BUSY        0x82
#define EMS_INVALID_HANDLE      0x83
#define EMS_NOT_IMPLEMENTED     0x84
#define EMS_NO_MORE_HANDLE      0x85
#define EMS_SAVE_REST_ERROR     0x86
#define EMS_LOG_GREATER_PH      0x87
#define EMS_LOG_GREATER_AVA     0x88
#define EMS_ZERO_ALLOC          0x89
#define EMS_INVALID_LOG         0x8a
#define EMS_INVALID_PH          0x8b
#define EMS_STATE_SAVE_FULL     0x8c
#define EMS_SAVE_ALREADY        0x8d
#define EMS_RESTORE_FAIL        0x8e
#define EMS_S_NOT_IMPLEMENTED   0x8f
#define EMS_SOURCE_OVERWRITTEN  0x92
#define EMS_SIZE_ERROR          0x93
#define EMS_OVERLAP             0x94
#define EMS_OFFSET_ERROR        0x95
#define EMS_TOO_BIG             0x96
#define EMS_OVERLAP_ERROR       0x97
#define EMS_UNDEFINED_TYPE      0x98
#define EMS_DUPLICATE           0xa1
#define EMS_WRAP_ERROR          0xa2

extern unsigned int EMS_Segment;

int EMS_Alloc(int *handle,int pages);
int EMS_AvailableLogPages(unsigned int *npages);
int EMS_PageAdress(int page,void far * far * pagept);
int EMS_TotalLogPages(unsigned int *npages);
int EMS_TotalPhPages(unsigned int *npages);
int EMS_Exchange(EMSMove *);
int EMS_Free(int handle);
int EMS_GetAllHandlePages(EMSHandle *p,int *entries);
int EMS_GetHandleCount(int *ActiveHandles);
int EMS_GetHandlePages(int handle,int *Pages);
int EMS_Exchange(EMSMove *);
int EMS_GetHandleName(int handle,char *name);
int EMS_GetNamedHandle(char *name,int *handle);
int EMS_Init(void);
int EMS_Map(int handle,int ppage,int lpage);
int EMS_MapMultipleEMS(int handle,int entries,EMSMap *parameter);
int EMS_Move(EMSMove *);
int EMS_Realloc(int handle,int pages);
int EMS_RestorePageMap(int handle);
int EMS_Status(void);
int EMS_SavePageMap(int handle);
int EMS_SetHandleName(int handle,char *name);
int EMS_Version(unsigned int *version);
