#include <scl1.h>
#include <scl1keys.h>

/* This file shows how to use ModifyPaletteColor to change palette settings
   in a VGA or EGA monitor */

static char PaldemoText1[]="   Up/Down arrow keys - modify background color  background color:\n"
        "Left/Right arrow keys - modify foreground color  foreground color:";

static char PaldemoText2[]="ESC to\n EXIT";

main()
{
int bcolor=0,fcolor=7;
char buffer[12];
unsigned int key;

/* we'll modify palette entry 0 (normally black) and palette entry 7 (white) */

InitVideo();
FillBlock(7,0,0,22,79,'X');         /* fill screen */
WriteScreen(7,23,0,PaldemoText1);   /* write message */
WriteScreen(7,23,73,PaldemoText2);

do
    {

    /* write palette entry values */

    sprintf(buffer,"0x%02x\n0x%02x",bcolor,fcolor);     
    WriteScreen(7,23,67,buffer);

    switch((key=GetKey()))
        {
        case UP:                /* let user modify value with keyboard */
            if(bcolor < 63)
                {
                ++bcolor;
                ModifyPaletteColor(0,bcolor);   /* modify palette */
                }
             break;
        case DOWN:
            if(bcolor > 0)
                {
                --bcolor;
                ModifyPaletteColor(0,bcolor);
                }
            break;
        case RIGHT:
            if(fcolor < 63)
                {
                ++fcolor;
                ModifyPaletteColor(7,fcolor);
                }
             break;
        case LEFT:
            if(fcolor > 0)
                {
                --fcolor;
                ModifyPaletteColor(7,fcolor);
                }
            break;
        }
    }while(key != ESC);
InitVideo();                /* restore to default */
}
