#include <scl1.h>
#include <scl1keys.h>
#include <scl1clor.h>

	/********************************************************************
	  MenuSystem2 example. You can display a help-line and gray-out menu
	  items with MenuSystem2  */

MSBar2 msb[]={

/* Menu-bar data:
	 Start and end column of each option
	 Menu's key SCAN-ASCII code
	 String */

	 1,6,0x2100," File ",
	 7,12,0x1200," Edit ",
	 };

/* first pull-down menu
	 row, column position
	 string
	 hot-key
	 1=active,0=inactive option
	 help text */

MSOptions2 mso0[]={
	 2,1," Load ",'L',1,"Load new file",
	 3,1," Save ",'S',0,"Save edited file",	/* inactive option */
	 4,1," Quit ",'Q',1,"Exit to DOS",
	 };

/* second pull-down menu */

MSOptions2 mso1[]={
	 2,7," Mark  ",'M',1,"Mark block",
	 3,7," Cut   ",'C',1,"Cut text block",
	 4,7," Copy  ",'y',1,"Copy text block",
	 5,7," Paste ",'P',1,"Paste text block",
	 };

/* buffer for storing pull down menu screen area */

char WindowBuf[140];

/* Pull-down menu box & window information
	 top left corner and bottom right corner positions
	 number of options
	 buffer for saving screen area
	 MSOptions structure  */

MSWindow2 msw[]={
	 1,0,5,7,3,WindowBuf,mso0,
	 1,6,6,14,4,WindowBuf,mso1,
	 };

/* This structure links all previous structures */

MSData2 msd=
	 {
   /* bar-menu colors */

	 BLACK_WHITE,WHITE_BLACK+HIGHLIGHT,

   /* pull-down menu colors */

	 WHITE_BLACK,BLACK_WHITE,WHITE_BLACK+HIGHLIGHT,

	/* normal and reverse color for inactive options */

	 BLACK_BLACK+HIGHLIGHT,BLACK_WHITE+HIGHLIGHT,

   /* MSBar, MSWindow structures, number of menus and internal variables */

	 msb,msw,2,0,0,0,

	 /* text color, line, column, and lenght */

	 BLACK_WHITE,24,0,80};

main()
{
int Mess;

InitMouse(IM_SHOW); /* initialize mouse */

/* Draw shadows */

MenuSystem2(MS_SHADOW_ON,(MSData *)0);

/* MenuSystem2 will be ALT sensitive */

MenuSystem2(MS_ALT_ON,(MSData *)0);

/* draw */

MenuSystem2(MS_DRAW,&msd);

do
     {

     /* a key pressed? */

     if(Mess=KeyReady())
          {

		  /* send key to MenuSystem2 */

		  Mess=MenuSystem2(MS_KEY,&msd,Mess);

		  /* If we still have a key it means it was not a MenuSystem2 key,
			 discard key. If your program needs to service the keyboard you
             should do it here. */

          if(KeyReady())
               GetKey();
          }
     else

		  /* Let MenuSystem2 check if the mouse has been clicked
             or a selection has been made */

		  Mess=MenuSystem2(MS_CHECK,&msd);

     if(Mess==MS_SELECT)
          {

          /* a selection was made, msd.Menu=selected menu */

          switch(msd.Menu)
               {
			   case 1:

               /* first menu, msd.Option=selected option */

                    switch(msd.Option)
                         {
                         case 1:

                              /* first option */

                              MessageOn(BLACK_WHITE,"Load");
                              WaitTime(100);
                              MessageOff();break;

                         case 2:

							  /* second option, since is inactive
							  we'll never receive this selection */

							  MessageOn(BLACK_WHITE,"Save");
							  WaitTime(100);
							  MessageOff();break;
						 case 3:

							  /* third option */

							  MessageOn(BLACK_WHITE,"Quit");
							  WaitTime(100);
							  MessageOff();
							  break;
							  }
					break;

			   case 2:

					/* second menu */

					switch(msd.Option)
						 {
						 case 1:
							  /* first option */

							  MessageOn(BLACK_WHITE,"Mark");
							  WaitTime(100);
							  MessageOff();
							  break;

						 case 2:
							  /* second option */

							  MessageOn(BLACK_WHITE,"Cut");
							  WaitTime(100);
							  MessageOff();
							  break;
						 case 3:
							  /* third option */

							  MessageOn(BLACK_WHITE,"Copy");
							  WaitTime(100);
							  MessageOff();
							  break;
						 case 4:
							  /* fourth option */

							  MessageOn(BLACK_WHITE,"Paste");
							  WaitTime(100);
							  MessageOff();
							  break;
						 }
					break;
			   }
		  }
	 }while(msd.Menu != 1 || msd.Option != 3);
}