#include <scl1.h>
#include <scl1keys.h>
#include <scl1clor.h>

 /****************************************************************
	 Shows the use of LineEditor function using a mask to define
	 acceptable characters. A '@' accepts letters and # accepts
	 digits, * accepts any character. */

char mask[]="@@##@";	/* mask to be used */

unsigned int ExitKeys[]={ENTER,ESC,0};   /* LineEd exit keys */

main()
{
LEData led;
int Mess;
char buffer[6];

Cls(WHITE_BLACK,CLS_ALL);               /* clear screen */
memset(buffer,0,sizeof(buffer));        /* initialize buffer */

/* initialize Line Editor structure */

LineEditor(LE_INIT,&led);

/* modify prompt and field position */

led.FRow=12;
led.FCol=35;
led.FLength=5;  /* the field's screen length is of 5 characters */
led.FSize=5;

led.CType=CC_ANY; 	       /* type of valid characters */
led.Buffer=buffer;    	   /* use our buffer */
led.ExitKeys=ExitKeys;     /* our defined exit keys */
PushCursor();              /* save cursor */
LineEditor(LE_DRAW,&led);  /* draw */

  /* Main loop: send ACTIVE message, LineEditor constantly
	 returns information */

do
	{
	Mess=LineEditor(LE_ACTIVE,&led);
	if(Mess==LE_ILLEGAL_KEY)        /* illegal key? */
		TSound(440,10);				/* beep */

	CheckMask(&led);				/* call our function to check mask */

	/* loop until an exit key is pressed */

	}while(Mess != LE_EXIT_KEY);

Cls(WHITE_BLACK,CLS_ALL);               /* clear screen */
}

CheckMask(LEData *led)
{
int i;

/* each time called this function will check the string in LineEditor
   and compare it with the mask */

i=strlen(led->Buffer)-1;
while(i >= 0)
	{
	switch(mask[i])
		{           /* digits only */
		case '#':
			if(!isdigit(led->Buffer[i]))
				goto Invalid;
			break;
		case '@':	/* letters only */

			if(!isalpha(led->Buffer[i]))
				goto Invalid;
			break;

		case '*':	/* accept anything */
			return;
		}
	--i;
	}
return;

/* in case an invalid character is detected we'll move LineEditor
   position to the invalid character. If insert mode is on (InFlag)
   we'll send the CHARS_DOWN message to LineEditor so that all
   characters that follow the invalid character are moved down. If
   insert mode is off we'll copy a space character to the current
   position */

Invalid:
	{
	led->Position=i;
	if(led->InsFlag)
		LineEditor(LE_CHARS_DOWN,led);
	else
		led->Buffer[i]=' ';

	LineEditor(LE_DRAW,led);	/* redraw */
	TSound(440,10);
	}
}