#include <scl1.h>

  /**********************************************************
    Shows the use of FindFirst/Next to get a directory list */

#define NO_MORE_FILES    18

static void printinfo(struct FileData *fd);

struct FileData fd; /* file info will be stored here */

main()
{
int RetVal;

RetVal=FindFirst("*.*",&fd,F_VOLUME);   /* read volume label */
if(RetVal==NO_MORE_FILES)               /* no more files? */
    printf("\nVolume has no label\n\n");
else
    printf("\nVolume label: %s\n\n",fd.name);

  /* read other files. Subdirectories, hidden, system and
     archive files */

RetVal=FindFirst("*.*",&fd,F_DIRECTORY | F_SYSTEM | F_HIDDEN);

     /* Get filenames while no error is reported */

while(RetVal==0)
    {
    printinfo(&fd);      /* print file information */
    RetVal=FindNext();   /* get next file */
    }
}

static void printinfo(struct FileData *fd)
{
printf("%-13s",fd->name); /* print file name */

     /* if file is not a directory, print file size */

if(fd->attrib == F_DIRECTORY)
    printf("  <DIR>");
else
    printf("%7li",fd->size);

/* print date and time */

printf("  %.2i-%.2i-%.2i  %.2i:%.2i:%.2i\n",fd->date.month,
           fd->date.day,fd->date.year+80,fd->time.hours,
           fd->time.minutes, fd->time.seconds);
}