#include <process.h>
#include <stdlib.h>
#include <errno.h>
#include <scl1.h>
#include <scl1clor.h>

/***************************************************************
   BackgroundOn/Off example. Displays a clock in the screen top
   right corner */

int hours,minutes,seconds;
char buffer[12];

int BackClock(void);

main()
{
char *p;

Cls(WHITE_BLACK,CLS_ALL);

GetTime();
hours=GT_Hours;
minutes=GT_Minutes;
seconds=GT_Seconds;

SetCurPos(2,0);
printf("A background clock will be active until you type EXIT\n");

BackgroundOn(BackClock);    /* set background function */

p=getenv("COMSPEC");

    /* run command.com */

if(p)
    {
    if(spawnl(P_WAIT,p,0))
        {
        if(errno == ENOMEM)
            printf("\nNot enough memory to load COMMAND.COM\n");
        else
            printf("\nUnable to load COMMAND.COM\n");
        }
    }
else
    printf("\nEnvironment Variable COMPSEC not found\n");

BackgroundOff();    /* stop background process */

ClearKeyBuf();
}

#pragma check_stack(off)

    /* this function will be called 18.2 per second */

int BackClock(void)
{
int i;
static int count=18;

    /* count variable is used to keep track of time. When count == 18 
       a second has elpased  */

if(count==18)
    {
    ++seconds;
    if(seconds == 60)
        {
        seconds=0;
        ++minutes;
        if(minutes == 60)
            {
            minutes=0;
            ++hours;
            if(hours == 24)
                hours=0;
            }
        }

    i=0;

    /* convert hours/minutes/seconds values to ASCII */

    if(hours < 10)
        buffer[i++]='0';

    itoa(hours,buffer+i,10);

    i=3;

    if(minutes < 10)
        buffer[i++]='0';

    itoa(minutes,buffer+i,10);

    i=6;
    if(seconds < 10)
        buffer[i++]='0';

    itoa(seconds,buffer+i,10);

    buffer[2]=':';
    buffer[5]=':';

    count=0;
    }

else
    ++count;

Box(BLACK_WHITE,0,0,69,2,78);
WriteScreen(BLACK_WHITE,1,70,buffer);
}
