//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// RefreshWorkSpace()
//
// Refreshes the entire workspace
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::RefreshWorkSpace()
{
  RemoveAllMenus();
  Blaze.Window(0,0,Blaze.WhatWidth(),Blaze.WhatHeight());
  Blaze.FreshWorkSpace();
  SetMenuBar(0,0,Blaze.WhatWidth());
  LastShift=KeyLast=500;
  RefreshPromptLine();

  if (NumberOfWindows)
  {
    int Width=Blaze.WhatWidth();
    int Height=Blaze.WhatHeight()-1;
    for (int i=0;i<NumberOfWindows;i++)
    {
      WindowElement &Window=*Windows[i];
      if (Window.X+Window.Width>Width)
      {
        if (Window.Width>Width)
        {
          Window.X=0;
          Window.Width=Width;
        }
        else
          Window.X=Width-Window.Width;
      }
      if (Window.Y+Window.Height>Height)
      {
        if (Window.Height>Height-1)
        {
          Window.Y=1;
          Window.Height=Height-1;
        }
        else
          Window.Y=Height-Window.Height;
      }
    }
  }

  RefreshWindows();
  MouseInControl=1;
  if (NumberOfWindows)
    Windows[0]->MouseInControl=1;
}

