//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// VirtualInterval()
//
// Interval between automated refreshment
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::VirtualInterval(int _Interval)
{
  VirtualizeInterval=_Interval;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// VirtualizeFresh()
//
// Refreshes all of the virtual windows
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::VirtualizeFresh()
{
  if (!NumberOfWindows)
    return;

  for (register int i=NumberOfWindows-1,j=0;i>=0;i--)
    if (Windows[i]->VirtualUpdate)
      j++;

  if (!j)
    return;

  char *EntireWindow=
    new char[Blaze.ComputeNeededBytes(Blaze.WhatWidth(),Blaze.WhatHeight())];

  Blaze.UseMemory(EntireWindow);
  Blaze.CharacterFill(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
    Colors.WorkSpace,176);

  for (i=NumberOfWindows-1;i>=0;i--)
  {
    Windows[i]->Blaze.UseMemory(EntireWindow);
    Windows[i]->ShowWindow();
    Windows[i]->ShowInterior();
    if (Windows[i]->VirtualUpdate)
      Windows[i]->EventHandler(VirtualEvent);
    Windows[i]->Blaze.UseVideo();
  }

  MouseHide();

  if (CurrentLevel)
  {
    for (int i=0;i<CurrentLevel;i++)
    {
      MenuItems &Menu=*SubMenuTrack[i];

      if (FusionShadowing)
      {
        int XShadow=1;
        int YShadow=1;

        if (Menu.X+Menu.Width==Blaze.WhatWidth())
          XShadow=0;

        if (Menu.Y+Menu.Width==Blaze.WhatHeight()-2)
          YShadow=0;

        Blaze.Shadow(Menu.X+XShadow,Menu.Y+YShadow,Menu.Width,Menu.Height);
      }

      Blaze.BlockCopyVisualToVirtual(Menu.X,Menu.Y,Menu.Width,
        Menu.Height,EntireWindow);
    }
  }
  else if (NumberOfWindows && Windows[0]->CurrentLevel)
  {
    for (int i=0;i<Windows[0]->CurrentLevel;i++)
    {
      MenuItems &Menu=*Windows[0]->SubMenuTrack[i];

      if (FusionShadowing)
      {
        int XShadow=1;
        int YShadow=1;

        if (Menu.X+Menu.Width==Blaze.WhatWidth())
          XShadow=0;

        if (Menu.Y+Menu.Width==Blaze.WhatHeight()-2)
          YShadow=0;

        Blaze.Shadow(Menu.X+XShadow,Menu.Y+YShadow,Menu.Width,Menu.Height);
      }

      Blaze.BlockCopyVisualToVirtual(Menu.X,Menu.Y,Menu.Width,
        Menu.Height,EntireWindow);
    }
  }

  Blaze.BlockCopyVirtualToVisual(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
    EntireWindow);

  MouseShow();

  Blaze.UseVideo();

  delete EntireWindow;

  Windows[0]->Cursor();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CheckVirtuals()
//
// Checks for virual presence
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int FusionWindow::CheckVirtuals()
{
  if (!NumberOfWindows)
    return 0;

  for (register int i=NumberOfWindows-1,j=0;i>=0;i--)
    if (Windows[i]->VirtualUpdate)
      j++;

  return j;
}

