//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// TileWindows()
//
// Tiles the windows
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::TileWindows()
{
  if (NumberOfWindows<2)
    return;

  int Calculation;
  int NumberOfWindows=FusionWindow::NumberOfWindows;
  int OddFlag=0;

  if (NumberOfWindows&1)
  {
    OddFlag=1;
    NumberOfWindows++;
  }

  Calculation=NumberOfWindows/2;

  if ((BlazeClass::WhatWidth()/Calculation)<13)
  {
    do { } while ((BlazeClass::WhatWidth()/(--Calculation))<13);
  }

  int WindowsOnScreen=Calculation*2;
  int SplitWindows=Calculation;
  int CurrentWindow=NumberOfWindows-1-((OddFlag)?1:0);
  int TopHeight=(BlazeClass::WhatHeight()-2)/2;
  int BottomHeight=(BlazeClass::WhatHeight()-2)-TopHeight;
  int BottomY=TopHeight+1;

  do
  {
    for (int i=0;i<WindowsOnScreen;i++)
    {
      if (CurrentWindow==-1)
        break;

      int X, Y, Width, Height, WidthAdjust=1;

      if (!CurrentWindow && i<WindowsOnScreen-1)
      {
        if (i<SplitWindows)
          WidthAdjust=(SplitWindows-i)+1;
        else
          WidthAdjust=(WindowsOnScreen-i)+1;
      }

      if (i<SplitWindows) // on top of screen
      {
        Y=1;
        Height=TopHeight;
        Width=((BlazeClass::WhatWidth())/SplitWindows)*WidthAdjust;
        X=i*(Width/WidthAdjust);
        if (X+Width>BlazeClass::WhatWidth())
          Width=Width-((X+Width)-BlazeClass::WhatWidth());
        else if (i==SplitWindows-1)
          Width+=(BlazeClass::WhatWidth()-(X+Width));
      }
      else // on bottom of screen
      {
        Y=BottomY;
        Height=BottomHeight;
        Width=((BlazeClass::WhatWidth())/SplitWindows)*WidthAdjust;
        X=((i-SplitWindows)*(Width/WidthAdjust));
        if (X+Width>BlazeClass::WhatWidth())
          Width=Width-((X+Width)-BlazeClass::WhatWidth());
        else if (i==WindowsOnScreen-1)
          Width+=(BlazeClass::WhatWidth()-(X+Width));
      }

      Windows[CurrentWindow]->X=X;
      Windows[CurrentWindow]->Y=Y;
      Windows[CurrentWindow]->Width=Width;
      Windows[CurrentWindow--]->Height=Height;
    }
  }
  while (CurrentWindow>=0);

  RemoveAllMenus();
  RefreshWindows();
}


