//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// MenuControl --> MenuItems --> FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// SubMenu()
//
// Adds a submenu
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuManager::SubMenu()
{
  if (!NumberOfMenus ||
    (NumberOfMenus && !Menus[NumberOfMenus-1]->NumberOfOptions))
    return;

  MenuItems *Localize;

  if (!CurrentLevel)
    Localize=Menus[NumberOfMenus-1];
  else
    Localize=SubMenuTrack[CurrentLevel-1];

  MenuItems &Quick=*Localize;
  _Options &QuickOption=*(Quick.Option+Quick.NumberOfOptions-1);

  QuickOption.SubMenu=new MenuItems();

  SubMenuTrack=(MenuItems**)realloc(SubMenuTrack,sizeof(MenuItems*)*++CurrentLevel);
  SubMenuTrack[CurrentLevel-1]=QuickOption.SubMenu;

  Localize->SubMenus++;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// EndSubMenu()
//
// Ends the addition of a submenu
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuManager::EndSubMenu()
{
  if (!CurrentLevel)
    return;

  CurrentLevel--;

  if (!CurrentLevel)
  {
    free(SubMenuTrack);
    SubMenuTrack=0;
  }
}

