//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// SizeWindow()
//
// Permits keyboard sizing of window
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::SizeWindow()
{
  if (!NumberOfWindows)
    return;

  BlazeClass::InvisibleCursor();

  RemoveAllMenus();

  WindowElement &Window=*Windows[0];

  if (!Window.SizeIcon)
    return;

  char *EntireWindow=
    new char[Blaze.ComputeNeededBytes(Blaze.WhatWidth(),Blaze.WhatHeight())];
  char *ThisWindow=
    new char[Blaze.ComputeNeededBytes(Window.Width,Window.Height)];

  Blaze.UseMemory(EntireWindow);
  Blaze.CharacterFill(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
    Colors.WorkSpace,176);

  Windows[0]->WindowZoomed=0;

  if (NumberOfWindows>1)
  {
    for (register int i=NumberOfWindows-1;i;i--)
    {
      Windows[i]->Blaze.UseMemory(EntireWindow);
      Windows[i]->ShowWindow();
      Windows[i]->ShowInterior();
      Windows[i]->Blaze.UseVideo();
    }
  }

  Blaze.GetArea(Window.X,Window.Y,Window.Width,Window.Height,ThisWindow);

  Blaze.HelpLine(0,"Use the keyboard to expand or contract the size of the window");

  Window.Blaze.UseMemory(EntireWindow);
  Window.ShowWindow();
  Window.ShowInterior();
  Window.Blaze.UseVideo();

  MouseHide();

  Blaze.BlockCopyVirtualToVisual(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
    EntireWindow);

  MouseShow();

  for (;;)
  {
    int Event=GetEvent();

    if (Event==MousedEvent && MouseEvent&MouseLeftButtonPress)
    {
      if ((Window.SizeIcon &&
           MouseVertical==Window.Y+Window.Height-1 &&
           MouseHorizontal==Window.X+Window.Width-1) ||
          (Window.Moveable &&
           MouseVertical==Window.Y &&
           MouseHorizontal>=(Window.X+(Window.CloseIcon*3)+1) &&
           MouseHorizontal<=(Window.X+Window.Width-(Window.ZoomIcon*3)-3)))
      {
        LastShift=500;
        KeyLast=500;
        delete ThisWindow;
        delete EntireWindow;
        Blaze.UseVideo();
        Window.ShowWindow();
        Window.ShowInterior();
        CheckMoveOrSize();
        return;
      }
    }

    if (Event==kbCr || Event==kbEsc)
    {
      LastShift=500;
      KeyLast=500;
      delete ThisWindow;
      delete EntireWindow;
      Blaze.UseVideo();
      Window.Cursor();
      Window.EventHandler(SizeEvent);
      return;
    }

    if (Event==kbRight || Event==kbLeft || Event==kbUp || Event==kbDown)
    {
      MouseHide();

      Blaze.PutArea(Window.X,Window.Y,ThisWindow);
      delete ThisWindow;

      int ActionX=0, ActionY=0;

      if (Event==kbRight)
        ActionX=1;
      else if (Event==kbLeft)
        ActionX=-1;
      else if (Event==kbUp)
        ActionY=-1;
      else
        ActionY=1;

      Window.Width+=ActionX;
      Window.Height+=ActionY;

      if (Window.Width<Window.MinimumWidth || Window.Width<13)
        Window.Width=Window.MinimumWidth;

      if (Window.Height<Window.MinimumHeight || Window.Height<5)
        Window.Height=Window.MinimumHeight;

      if (Window.X+Window.Width>Blaze.WhatWidth())
        Window.Width=Blaze.WhatWidth()-Window.X;

      if (Window.Y+Window.Height>Blaze.WhatHeight()-1)
        Window.Height=Blaze.WhatHeight()-Window.Y-1;

      ThisWindow=
        new char[Blaze.ComputeNeededBytes(Window.Width,Window.Height)];
      Blaze.GetArea(Window.X,Window.Y,Window.Width,Window.Height,ThisWindow);
      Window.Blaze.UseMemory(EntireWindow);
      Window.ShowWindow();
      Window.ShowInterior();
      Window.Blaze.UseVideo();

      MouseHide();

      Blaze.BlockCopyVirtualToVisual(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
        EntireWindow);

      MouseShow();
    }
  }
}

