//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// MenuControl --> MenuItems --> FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <stdarg.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Selectable()
//
// Adds a list of selectables to a menu option
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuManager::Selectable(int &Item ...)
{
  if (!NumberOfMenus)
    return;

  if (!CurrentLevel)
  {
    _Options &Option=*(Menus[NumberOfMenus-1]->Option+
      Menus[NumberOfMenus-1]->NumberOfOptions-1);

    Option.Selectable=&Item;

    va_list SelectableList;

    va_start(SelectableList,Item);
    while (va_arg(SelectableList,char *)!=0)
      Option.SelectCount++;
    va_end(SelectableList);

    Option.Selectables=new char*[Option.SelectCount];

    int Count=0;
    char *Pointer;
    va_start(SelectableList,Item);
    while ((Pointer=va_arg(SelectableList,char *))!=0)
      Option.Selectables[Count++]=Pointer;
    va_end(SelectableList);

    Menus[NumberOfMenus-1]->Selectables++;
  }
  else
  {
    _Options &Option=*(SubMenuTrack[CurrentLevel-1]->Option+
      SubMenuTrack[CurrentLevel-1]->NumberOfOptions-1);

    Option.Selectable=&Item;

    va_list SelectableList;

    va_start(SelectableList,Item);
    while (va_arg(SelectableList,char *)!=0)
      Option.SelectCount++;
    va_end(SelectableList);

    Option.Selectables=new char*[Option.SelectCount];

    int Count=0;
    char *Pointer;
    va_start(SelectableList,Item);
    while ((Pointer=va_arg(SelectableList,char *))!=0)
      Option.Selectables[Count++]=Pointer;
    va_end(SelectableList);

    SubMenuTrack[CurrentLevel-1]->Selectables++;
  }
}

