//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// MenuControl --> MenuItems --> FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>
#include <string.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// BlankLine()
//
// Defines a blank line on a pulldown menu
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuManager::BlankLine()
{
  Option(0,0,0);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Option()
//
// Defines a new option on a pulldown menu
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuItems::_Option(char *Option,char *Help,int FusionEvent,
  char *HotKey,int Key)
{
  static int Available=1;

  MenuItems::Option=
    (_Options*)realloc(MenuItems::Option,(++NumberOfOptions)*sizeof(_Options));

  _Options &Item=*(MenuItems::Option+NumberOfOptions-1);

  if (HotKey)
    HotKeys++;

  Height++;

  Item.Option=Option;
  Item.Help=Help;
  Item.HotKeyOption=HotKey;
  Item.HotKey=Key;
  Item.QuickKey=0;
  Item.Event=FusionEvent;
  Item.Available=&Available;
  Item.SubMenu=0;
  Item.Checked=0;
  Item.SelectCount=0;
  Item.Selectable=0;
  Item.Selectables=0;
  Item.WidestSelectable=0;
}

void MenuManager::Option(char *Option,char *Help,int FusionEvent,
  char *HotKey,int Key)
{
  if (!NumberOfMenus)
    return;

  if (!CurrentLevel)
    Menus[NumberOfMenus-1]->_Option(Option,Help,FusionEvent,HotKey,Key);
  else
    SubMenuTrack[CurrentLevel-1]->_Option(Option,Help,FusionEvent,HotKey,Key);
}

