//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>
#include <stdio.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// NewWindow()
//
// Opens a new window and places it in queue
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int FusionWindow::NewWindow(WindowElement *WindowToOpen,char *Title,int NoShow)
{
  if (MaxWindows && NumberOfWindows==MaxWindows)
  {
    InfoBox &TooManyWindows = *new InfoBox;
    char Maximum[50];
    sprintf(Maximum,"%d open window(s) at a time.",MaxWindows);
    TooManyWindows
          + "Sorry, you cannot open any more windows."
          + ""
          + "This application permits a maximum of"
          + Maximum;
    TooManyWindows.Title("Too Many Windows");
    TooManyWindows.UseInfoBox();
    delete &TooManyWindows;
    delete WindowToOpen;
    return 0;
  }

  RemoveAllMenus();

  Windows=(WindowElement**)realloc(Windows,++NumberOfWindows*sizeof(WindowElement*));

  if (NumberOfWindows>1)
  {
    Windows[0]->Active=0;
    if (!NoShow)
    {
      Windows[0]->ShowWindow();
      Windows[0]->ShowInterior();
    }
    for (register int i=NumberOfWindows-2;i>=0;i--)
      Windows[i+1]=Windows[i];
  }

  Windows[0]=WindowToOpen;

  if (Title)
    WindowToOpen->Title=Title;

  WindowToOpen->Active=1;
  WindowToOpen->MainHandler=this;

  for (register int i=1,k=0;i<10;i++,k=0)
  {
    for (register int j=0;j<NumberOfWindows;j++)
    {
      if (Windows[j]->WindowNumber==i)
      {
        k++;
        break;
      }
    }
    if (!k)
    {
      WindowToOpen->WindowNumber=i;
      break;
    }
  }

  if (!NoShow)
  {
    WindowToOpen->ShowWindow();
    WindowToOpen->ShowInterior();
  }

  return 1;
}

