//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// MenuControl --> MenuItems --> FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// NewMenu()
//
// Defines a new pulldown menu
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuManager::NewMenu(char *Menu,char *Help,int MenuHotKey,int Event)
{
  if (CurrentLevel)
  {
    free(SubMenuTrack);
    CurrentLevel=0;
    SubMenuTrack=0;
  }
  Menus=(MenuItems**)realloc(Menus,++NumberOfMenus*sizeof(MenuItems*));
  Menus[NumberOfMenus-1]=new MenuItems();
  Menus[NumberOfMenus-1]->MenuHelp=Help;
  Menus[NumberOfMenus-1]->Title=Menu;
  Menus[NumberOfMenus-1]->MenuHotKey=MenuHotKey;
  Menus[NumberOfMenus-1]->MenuEvent=Event;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// RemoveAllMenus()
//
// Removes all menus from the display
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuManager::RemoveAllMenus()
{
  if (!CurrentLevel)
    return;

  int CurrentLevel=MenuManager::CurrentLevel;

  for (int i=0;i<CurrentLevel;i++)
    RemoveMenu();

  MouseInControl=1;
}

