//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"
#include "elements.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ListAndSelect()
//
// List and select from the current array of windows
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

const winAcceptButton=32765;
const winCancelButton=32766;

class ListDialog : public DialogClass
{
public:

  ListDialog(int Width,int Height) :
    DialogClass(Width,Height,"Window Select") { }

  int EventHandler(int Event)
  {
    if (Event==kbEsc ||
        Event==kbCr ||
        Event==CloseEvent ||
        Event==OutsideEvent ||
        Event==winAcceptButton ||
        Event==winCancelButton)
      return StopEvent;
    return CompleteEvent;
  }
};

void FusionWindow::ListAndSelect()
{
  if (!NumberOfWindows)
    return;

  char **Titles=(char**)malloc(NumberOfWindows*sizeof(char*));

  for (int i=0;i<NumberOfWindows;i++)
    Titles[i]=Windows[i]->Title;

  ListDialog &Dialog=*new ListDialog(60,15);

  int WindowToSelect=0;

  Dialog.Element(new DiaPickList(1,2,53,8,WindowToSelect,NumberOfWindows,Titles));
  Dialog.FusionHelp(32767);
  Dialog.HotKey(1,1,"~Select a Window",kbAltS);
  Dialog.Help("These are the windows");

  Dialog.Element(new DiaPushButton(8,11,"~Choose This Window",winAcceptButton,kbAltC));
  Dialog.Help("Choose the highlighted and jump to it");

  Dialog.Element(new DiaPushButton(36,11,"Stay ~Here",winCancelButton,kbAltH));
  Dialog.Help("Cancel and return to the menu, without selecting a window");

  int Value=Dialog.UseDialog();

  delete &Dialog;
  free(Titles);

  if (Value==kbEsc || Value==OutsideEvent || Value==CloseEvent || Value==winCancelButton)
    return;
  else
  {
    RemoveAllMenus();
    if (WindowToSelect)
      CallWindow(WindowToSelect);
  }
}

