//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// IndexCardWindows()
//
// Indexes the windows
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::IndexCardWindows()
{
  if (NumberOfWindows<2)
    return;

  int CurrentY=1;
  int CurrentHeight=10;
  int CurrentX=0;
  int CurrentWidth=30;
  int OverFactor=0;

  for (int i=NumberOfWindows-1;i>=0;i--)
  {
    Windows[i]->X=CurrentX;
    Windows[i]->Y=CurrentY;
    Windows[i]->Width=(CurrentWidth<Windows[i]->MinimumWidth)?Windows[i]->MinimumWidth:CurrentWidth;
    Windows[i]->Height=CurrentHeight;

    CurrentY++;
    CurrentX++;

    if (CurrentY+CurrentHeight>BlazeClass::WhatHeight()-1)
    {
      OverFactor+=10;
      CurrentX=OverFactor;
      CurrentY=1;
    }

    if (CurrentX+CurrentWidth>BlazeClass::WhatWidth())
    {
      OverFactor=0;
      CurrentX=OverFactor;
      CurrentY=1;
    }
  }

  RemoveAllMenus();
  RefreshWindows();
}
