//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// RefreshWindows()
//
// Refreshes all of the windows
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::RefreshWindows()
{
  if (!NumberOfWindows)
    return;

  RemoveAllMenus();

  char *EntireWindow=
    new char[Blaze.ComputeNeededBytes(Blaze.WhatWidth(),Blaze.WhatHeight())];

  Blaze.UseMemory(EntireWindow);
  Blaze.CharacterFill(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
    Colors.WorkSpace,176);

  for (register int i=NumberOfWindows-1;i>=0;i--)
  {
    Windows[i]->Blaze.UseMemory(EntireWindow);
    Windows[i]->ShowWindow();
    Windows[i]->ShowInterior();
    Windows[i]->Blaze.UseVideo();
  }

  MouseHide();

  Blaze.BlockCopyVirtualToVisual(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
    EntireWindow);

  MouseShow();

  Blaze.UseVideo();

  delete EntireWindow;

  Windows[0]->Cursor();
}

