//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CheckEcho()
//
// Checks for a signaling echo
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int FusionWindow::CheckEcho()
{
  if (!NumberOfWindows)
    return 0;

  return Windows[0]->Echo();
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CheckForEcho()
//
// Checks all windows for a signaling echo
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int FusionWindow::CheckForEcho(int Signal)
{
  if (!NumberOfWindows)
    return 0;

  for (int i=0,j=0;i<NumberOfWindows;i++)
    if (Windows[i]->Echo()==Signal)
      j++;

  return j;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CloseEcho(int Echo)
//
// Closes all windows matching an echoing signal
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::CloseEcho(int Echo)
{
TryAgain:

  if (!NumberOfWindows)
    return;

  if (!Echo)
  {
    int WinCount=NumberOfWindows;
    for (int i=0;i<WinCount;i++)
      CloseWindow();
  }
  else
  {
    for (int i=0;i<NumberOfWindows;i++)
    {
      if (Echo==Windows[i]->Echo())
      {
        CallWindow(i);
        CloseWindow();
        goto TryAgain;
      }
    }
  }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// FreshEcho(int Echo)
//
// Freshes all windows (currently doesn't respond to echo)
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#pragma warn -par

void FusionWindow::FreshEcho(int Echo)
{
  RefreshWindows();
}

#pragma warn .par
