//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CloseWindow()
//
// Closes the current window
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void FusionWindow::CloseWindow()
{
  if (!NumberOfWindows)
    return;

  RemoveAllMenus();

  BlazeClass::InvisibleCursor();

  delete Windows[0];

  if (NumberOfWindows>1)
  {
    for (register int i=0;i<NumberOfWindows-1;i++)
      Windows[i]=Windows[i+1];
    NumberOfWindows--;
    Windows[0]->Active=1;
    RefreshWindows();
  }
  else
  {
    free(Windows);
    Windows=0;
    NumberOfWindows=0;
    MouseHide();
    Blaze.CharacterFill(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
      Colors.WorkSpace,176);
    MouseShow();
  }
}

