//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// FusionWindow
//

#include "fliwin.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CheckMoveOrSize()
//
// Checks the current window and moves or sizes it
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

int FusionWindow::CheckMoveOrSize()
{
  if (!NumberOfWindows)
    return 0;

  WindowElement &Window=*Windows[0];

  //--------------------------------------------------------------------------
  //
  // Size the window
  //
  //--------------------------------------------------------------------------

  if (Window.SizeIcon
    && MouseVertical==Window.Y+Window.Height-1
    && MouseHorizontal==Window.X+Window.Width-1)
  {
    RemoveAllMenus();

    BlazeClass::InvisibleCursor();

    if (NumberOfWindows && Windows[0]->CurrentLevel)
      Windows[0]->RemoveAllMenus();

    int ActionX=MouseHorizontal;
    int ActionY=MouseVertical;

    char *EntireWindow=
      new char[Blaze.ComputeNeededBytes(Blaze.WhatWidth(),Blaze.WhatHeight())];
    char *ThisWindow=
      new char[Blaze.ComputeNeededBytes(Window.Width,Window.Height)];

    Blaze.UseMemory(EntireWindow);
    Blaze.CharacterFill(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
      Colors.WorkSpace,176);

    Windows[0]->WindowZoomed=0;

    if (NumberOfWindows>1)
    {
      for (register int i=NumberOfWindows-1;i;i--)
      {
        Windows[i]->Blaze.UseMemory(EntireWindow);
        Windows[i]->ShowWindow();
        Windows[i]->ShowInterior();
        Windows[i]->Blaze.UseVideo();
      }
    }

    Blaze.GetArea(Window.X,Window.Y,Window.Width,Window.Height,ThisWindow);

    Blaze.HelpLine(0,"Use the mouse to expand or contract the size of the window");

    Window.Blaze.UseMemory(EntireWindow);
    Window.ShowWindow();
    Window.ShowInterior();
    Window.Blaze.UseVideo();

    MouseHide();

    Blaze.BlockCopyVirtualToVisual(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
      EntireWindow);

    MouseShow();

    for (;;)
    {
      GetEvent();

      if (MouseEvent&4)
      {
        LastShift=500;
        KeyLast=500;
        delete ThisWindow;
        delete EntireWindow;
        Blaze.UseVideo();
        Window.Cursor();
        Window.EventHandler(SizeEvent);
        return 1;
      }

      if (MouseEvent&1)
      {
        MouseHide();

        Blaze.PutArea(Window.X,Window.Y,ThisWindow);
        delete ThisWindow;

        Window.Width+=(MouseHorizontal-ActionX);
        Window.Height+=(MouseVertical-ActionY);

        ActionX=MouseHorizontal;
        ActionY=MouseVertical;

        if (Window.Width<Window.MinimumWidth || Window.Width<13)
          Window.Width=Window.MinimumWidth;

        if (Window.Height<Window.MinimumHeight || Window.Height<5)
          Window.Height=Window.MinimumHeight;

        if (Window.X+Window.Width>Blaze.WhatWidth())
          Window.Width=Blaze.WhatWidth()-Window.X;

        if (Window.Y+Window.Height>Blaze.WhatHeight()-1)
          Window.Height=Blaze.WhatHeight()-Window.Y-1;

        ThisWindow=
          new char[Blaze.ComputeNeededBytes(Window.Width,Window.Height)];
        Blaze.GetArea(Window.X,Window.Y,Window.Width,Window.Height,ThisWindow);
        Window.Blaze.UseMemory(EntireWindow);
        Window.ShowWindow();
        Window.ShowInterior();
        Window.Blaze.UseVideo();

        MouseHide();

        Blaze.BlockCopyVirtualToVisual(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
          EntireWindow);

        MouseShow();

        if (MouseVertical!=Window.Y+Window.Height-1 ||
          MouseHorizontal!=Window.X+Window.Width-1)
        {
          MousePosition(Window.X+Window.Width-1,Window.Y+Window.Height-1);
          MouseLocate();
          ActionX=MouseHorizontal;
          ActionY=MouseVertical;
        }
      }
    }
  }

  //--------------------------------------------------------------------------
  //
  // Move the window
  //
  //--------------------------------------------------------------------------

  if (Window.Moveable
    && MouseVertical==Window.Y
    && MouseHorizontal>=(Window.X+(Window.CloseIcon*3)+1)
    && MouseHorizontal<=(Window.X+Window.Width-(Window.ZoomIcon*3)-3))
  {
    int ExactX=MouseHorizontal-Window.X;
    int ExactY=MouseVertical-Window.Y;

    RemoveAllMenus();

    BlazeClass::InvisibleCursor();

    if (NumberOfWindows && Windows[0]->CurrentLevel)
      Windows[0]->RemoveAllMenus();

    int ActionX=MouseHorizontal;
    int ActionY=MouseVertical;

    char *EntireWindow=
      new char[Blaze.ComputeNeededBytes(Blaze.WhatWidth(),Blaze.WhatHeight())];
    char *ThisWindow=
      new char[Blaze.ComputeNeededBytes(Window.Width,Window.Height)];
    char *SpareWindow=
      new char[Blaze.ComputeNeededBytes(Window.Width,Window.Height)];

    Blaze.UseMemory(EntireWindow);
    Blaze.CharacterFill(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
      Colors.WorkSpace,176);

    if (NumberOfWindows>1)
    {
      for (register int i=NumberOfWindows-1;i;i--)
      {
        Windows[i]->Blaze.UseMemory(EntireWindow);
        Windows[i]->ShowWindow();
        Windows[i]->ShowInterior();
        Windows[i]->Blaze.UseVideo();
      }
    }

    Blaze.HelpLine(0,"Use the mouse to move the window");

    Blaze.GetArea(Window.X,Window.Y,Window.Width,Window.Height,ThisWindow);

    Window.Blaze.UseMemory(EntireWindow);
    Window.ShowWindow();
    Window.ShowInterior();
    Window.Blaze.UseVideo();

    MouseHide();

    Blaze.BlockCopyVirtualToVisual(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
      EntireWindow);
    Blaze.GetArea(Window.X,Window.Y,Window.Width,Window.Height,SpareWindow);

    MouseShow();

    for (;;)
    {
      GetEvent();

      if (MouseEvent&4)
      {
        LastShift=500;
        KeyLast=500;
        delete SpareWindow;
        delete ThisWindow;
        delete EntireWindow;
        Blaze.UseVideo();
        Window.ReAlign();
        Window.Cursor();
        Window.EventHandler(MoveEvent);
        return 1;
      }

      if (MouseEvent&1)
      {
        MouseHide();

        Blaze.PutArea(Window.X,Window.Y,ThisWindow);
        delete ThisWindow;

        Window.X+=(MouseHorizontal-ActionX);
        Window.Y+=(MouseVertical-ActionY);

        ActionX=MouseHorizontal;
        ActionY=MouseVertical;

        if (Window.X<0)
          Window.X=0;

        if (Window.Y<1)
          Window.Y=1;

        if (Window.X+Window.Width>Blaze.WhatWidth())
          Window.X=Blaze.WhatWidth()-Window.Width;

        if (Window.Y+Window.Height>Blaze.WhatHeight()-1)
          Window.Y=Blaze.WhatHeight()-Window.Height-1;

        MouseHide();

        ThisWindow=
          new char[Blaze.ComputeNeededBytes(Window.Width,Window.Height)];
        Blaze.GetArea(Window.X,Window.Y,Window.Width,Window.Height,ThisWindow);
        Blaze.PutArea(Window.X,Window.Y,SpareWindow);
        Blaze.BlockCopyVirtualToVisual(0,1,Blaze.WhatWidth(),Blaze.WhatHeight()-2,
          EntireWindow);

        MouseShow();

        if (MouseVertical!=Window.Y+ExactY ||
          MouseHorizontal!=Window.X+ExactX)
        {
          MousePosition(Window.X+ExactX,Window.Y+ExactY);
          MouseLocate();
          ActionX=MouseHorizontal;
          ActionY=MouseVertical;
        }
      }
    }
  }
  return 0;
}

