//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// MenuAlteration --> MenuControl --> MenuItems --> FusionWindow
//

#include "fliwin.h"
#include "colors.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <alloc.h>
#include <string.h>
#include <mem.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// SetMenus()
//
// Resets the menu bar and redraws it
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuAlteration::SetMenus()
{
  RemoveAllMenus();
  SetMenuBar(SetX,SetY,StowedWidth,0);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DeleteLastMenu()
//
// Removes Last Added Menu
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuAlteration::DeleteLastMenu()
{
  RemoveAllMenus();

  if (!NumberOfMenus)
    return;

  delete Menus[(NumberOfMenus--)-1];
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DeleteAllMenus()
//
// Removes *ALL* Menus
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuAlteration::DeleteAllMenus()
{
  RemoveAllMenus();

  if (!NumberOfMenus)
    return;

  for (int i=0;i<NumberOfMenus;i++)
    delete Menus[i];

  free(Menus);

  Menus=0;
  SubMenuTrack=0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DeleteMenu()
//
// Removes a particular menu that has Event as its event code
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuAlteration::DeleteMenu(int Event)
{
  RemoveAllMenus();

  if (!NumberOfMenus)
    return;

  for (int i=0;i<NumberOfMenus;i++)
  {
    if (Menus[i]->MenuEvent==Event)
    {
      if (NumberOfMenus==1)
        DeleteAllMenus();
      else
      {
        delete Menus[i];
        if (i==NumberOfMenus-1)
          NumberOfMenus--;
        else
          movmem(Menus[i+1],Menus[i],(NumberOfMenus-i)-1);
      }
      break;
    }
  }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// GrabThis()
//
// Scan menu for an event code
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

MenuItems *MenuAlteration::GrabThis(int Event,MenuItems *Scan)
{
  for (int i=0;i<Scan->NumberOfOptions;i++)
  {
    _Options &Option=*(Scan->Option+i);

    if (Event==Option.Event)
      return Scan;
  }

  for (i=0;i<Scan->NumberOfOptions;i++)
  {
    _Options &Option=*(Scan->Option+i);

    if (Option.SubMenu)
    {
      if (!*Option.Available || !Option.Option)
        continue;

      MenuItems *Save=GrabThis(Event,Option.SubMenu);

      if (Save)
        return Save;
    }
  }

  return 0;
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// DeleteOption()
//
// Removes a particular option that has Event as its event code
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuAlteration::DeleteOption(int Event)
{
  RemoveAllMenus();

  if (!NumberOfMenus)
    return;

  for (int j=0;j<NumberOfMenus;j++)
  {
    MenuItems *GrabIt=GrabThis(Event,Menus[j]);

    if (GrabIt)
    {
      for (int i=0;i<GrabIt->NumberOfOptions;i++)
      {
        if ((GrabIt->Option+i)->Event==Event)
        {
          if ((GrabIt->Option+i)->SubMenu)
          {
            delete (GrabIt->Option+i)->SubMenu;
            GrabIt->SubMenus--;
          }
          if (GrabIt->NumberOfOptions==1)
          {
            free(GrabIt->Option);
            GrabIt->Option=0;
            GrabIt->NumberOfOptions=0;
          }
          else if (GrabIt->NumberOfOptions-1==i)
          {
            if ((GrabIt->Option+i)->Selectables)
            {
              delete (GrabIt->Option+i)->Selectables;
              GrabIt->Selectables--;
            }
            if ((GrabIt->Option+i)->Checked)
              GrabIt->Checkables--;
            GrabIt->NumberOfOptions--;
          }
          else
          {
            if ((GrabIt->Option+i)->Selectables)
            {
              delete (GrabIt->Option+i)->Selectables;
              GrabIt->Selectables--;
            }
            if ((GrabIt->Option+i)->Checked)
              GrabIt->Checkables--;
            movmem((GrabIt->Option+i+1),(GrabIt->Option+i),
              sizeof(_Options)*((GrabIt->NumberOfOptions-i)-1));
            GrabIt->NumberOfOptions--;
          }
          return;
        }
      }
      return;
    }
  }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// ChangeOption()
//
// Changes a particular option to a new format
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void MenuAlteration::ChangeOption(int Event,char *NewTitle,char *NewHelp,
  int NewEventCode,char *NewHotKey,int NewKeyCode)
{
  RemoveAllMenus();

  if (!NumberOfMenus)
    return;

  for (int j=0;j<NumberOfMenus;j++)
  {
    MenuItems *GrabIt=GrabThis(Event,Menus[j]);

    if (GrabIt)
    {
      for (int i=0;i<GrabIt->NumberOfOptions;i++)
      {
        if ((GrabIt->Option+i)->Event==Event)
        {
          _Options &Option=*(GrabIt->Option+i);

          Option.Help=NewHelp;
          Option.Option=NewTitle;
          Option.Event=NewEventCode;
          Option.HotKey=NewKeyCode;
          Option.HotKeyOption=NewHotKey;
          return;
        }
      }
      return;
    }
  }
}

