//
// The Fusion Library Interface for DOS
// Version 1.06c
// Copyright (C) 1990, 1991, 1992
// Software Dimensions
//
// NumberMask
//

#include "fli.h"

#ifdef __BCPLUSPLUS__
#pragma hdrstop
#endif

#include <ctype.h>
#include <string.h>
#include <alloc.h>

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// CountPlaces()
//
// Counts # of digits before and after the decimal place
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void NumberMask::CountPlaces(char *Mask,int &Before,int &After)
{
  char *DiscardableMask=strchr(Mask,'.');
  char *SecondDiscardableMask=DiscardableMask;

  After=0;
  Before=0;

  if (DiscardableMask)
  {
    DiscardableMask++;
    while (*DiscardableMask)
    {
      if (*DiscardableMask=='#')
        After++;
      DiscardableMask++;
    }
  }

  if (!SecondDiscardableMask)
    SecondDiscardableMask=Mask+strlen(Mask)-1;

  do
  {
    if (*SecondDiscardableMask=='#')
      Before++;
  }
  while ((SecondDiscardableMask--)!=Mask);
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// MaskShow()
//
// Handles displaying numbers within a mask
//
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

void NumberMask::MaskShow(char *_Mask,char *Value,BlazeClass &Blaze)
{
  char *Position;

  if (Position=strchr(Value,'.'),Position) // Failsafe - strip leading zeros
  {
    int ZeroCount=0;
    int OtherCount=0;
    Position--;
    do
    {
      if (isdigit(*Position))
      {
        if (*Position!='0')
        {
          OtherCount++;
          break;
        }
        else
          ZeroCount++;
      }
      Position--;
    } while (Position>=Value);

    if (!OtherCount && ZeroCount)
    {
      Position=Value;
      if (*Position=='-')
        Position++;
      do
      {
        memmove(Position,Position+1,strlen(Position)+1);
      } while (*Position!='.');
    }
  }

  char *Mask=strdup(_Mask);

  if (!*Value)
  {
    *Value='0';
    *(Value+1)=0;
  }

  char *ValueDecimals=strchr(Value,'.');
  char *MaskDecimals=strchr(Mask,'.');

  char *SecondValueDecimals=ValueDecimals;
  char *SecondMaskDecimals=MaskDecimals;

  if (ValueDecimals)
  {
    ValueDecimals++;
    SecondValueDecimals--;
  }

  if (MaskDecimals)
  {
    while (*MaskDecimals)
    {
      if (*MaskDecimals=='#' && (!ValueDecimals || !*ValueDecimals))
        *MaskDecimals='0';
      else if (*MaskDecimals=='#' && ValueDecimals)
        *MaskDecimals=*ValueDecimals++;
      MaskDecimals++;
    }
  }

  if (!SecondMaskDecimals)
    SecondMaskDecimals=Mask+strlen(Mask)-1;

  if (!SecondValueDecimals)
    SecondValueDecimals=Value+strlen(Value)-1;

  do
  {
    if ((*SecondMaskDecimals=='#' || *SecondMaskDecimals==',') &&
        (SecondValueDecimals==Value-1 || *SecondValueDecimals=='-'))
      *SecondMaskDecimals=' ';
    else if (*SecondMaskDecimals=='#' && SecondValueDecimals!=Value-1)
      *SecondMaskDecimals=*SecondValueDecimals--;
  }
  while ((SecondMaskDecimals--)!=Mask);

  char *Locator;

  if ((Locator=strchr(Mask,'-'),Locator) && !strchr(Value,'-'))
    *Locator=' ';

  if ((Locator=strchr(Mask,'+'),Locator) && strchr(Value,'-'))
    *Locator='-';

  if ((Locator=strchr(Mask,'('),Locator) && !strchr(Value,'-'))
  {
    *Locator=' ';
    if (Locator=strchr(Mask,')'),Locator)
      *Locator=' ';
  }

  if (SecondValueDecimals>Value-1 && *SecondValueDecimals!='-')
    strnset(Mask,'*',strlen(Mask)); // OVERFLOW

  Blaze << Mask;

  free(Mask);
}


